/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.vaadin.chartjs;

import com.byteowls.vaadin.chartjs.ChartJsState;
import com.byteowls.vaadin.chartjs.config.ChartConfig;
import com.vaadin.annotations.JavaScript;
import com.vaadin.ui.AbstractJavaScriptComponent;
import com.vaadin.ui.JavaScriptFunction;
import elemental.json.JsonArray;
import java.util.ArrayList;
import java.util.List;

@JavaScript(value={"vaadin://chartjs/Chart.min.js", "vaadin://chartjs/hammer.min.js", "vaadin://chartjs/chartjs-plugin-zoom.min.js", "vaadin://chartjs/chartjs-connector.js"})
public class ChartJs
extends AbstractJavaScriptComponent {
    private static final long serialVersionUID = 2999562112373836140L;
    private List<DataPointClickListener> dataPointClickListeners = new ArrayList<DataPointClickListener>();
    private ChartConfig chartConfig;

    public ChartJs() {
        this.addJsFunctions();
    }

    public ChartJs(ChartConfig chartConfig) {
        this.configure(chartConfig);
        this.addJsFunctions();
    }

    public void configure(ChartConfig chartConfig) {
        if (chartConfig != null) {
            this.chartConfig = chartConfig;
        }
    }

    public void attach() {
        if (this.chartConfig != null) {
            this.getState().configurationJson = this.chartConfig.buildJson();
        }
        super.attach();
    }

    public ChartConfig getConfig() {
        return this.chartConfig;
    }

    public void refreshData() {
        if (this.chartConfig != null) {
            this.getState().configurationJson = this.chartConfig.buildJson();
        }
        this.callFunction("updateData", new Object[0]);
    }

    public boolean isJsLoggingEnabled() {
        return this.getState().loggingEnabled;
    }

    public void setJsLoggingEnabled(boolean jsLoggingEnabled) {
        this.getState().loggingEnabled = jsLoggingEnabled;
    }

    public void addClickListener(DataPointClickListener listener) {
        this.dataPointClickListeners.add(listener);
        this.checkListenerState();
    }

    public void removeClickListener(DataPointClickListener listener) {
        this.dataPointClickListeners.remove(listener);
        this.checkListenerState();
    }

    private void checkListenerState() {
        this.getState().dataPointClickListenerFound = !this.dataPointClickListeners.isEmpty();
    }

    private void addJsFunctions() {
        this.addFunction("onDataPointClick", new JavaScriptFunction(){
            private static final long serialVersionUID = -6280339244713509848L;

            public void call(JsonArray arguments) {
                int datasetIndex = (int)arguments.getNumber(0);
                int dataIndex = (int)arguments.getNumber(1);
                for (DataPointClickListener l : ChartJs.this.dataPointClickListeners) {
                    l.onDataPointClick(datasetIndex, dataIndex);
                }
            }
        });
    }

    protected ChartJsState getState() {
        return (ChartJsState)super.getState();
    }

    public static interface DataPointClickListener {
        public void onDataPointClick(int var1, int var2);
    }
}

