package com.byteowls.vaadin.chartjs.options.scale;

import com.byteowls.vaadin.chartjs.utils.JUtils;

import elemental.json.JsonObject;

/**
 * The linear scale is use to chart numerical data. It can be placed on either the x or y axis.
 * The scatter chart type automatically configures a line chart to use one of these scales for the x axis.
 * As the name suggests, linear interpolation is used to determine where a value lies on the axis.
 *
 * @author michael@byteowls.com
 */
public class LinearScale extends BaseScale<LinearScale> {

    private LinearTicks<LinearScale> linearTicks;

    public LinearScale() {
        type("linear");
    }

    /**
     * It defines options for the tick marks that are generated by the axis.
     */
    @Override
    public LinearTicks<LinearScale> ticks() {
        if (this.linearTicks == null) {
            this.linearTicks = new LinearTicks<>(getThis());
        }
        return this.linearTicks;
    }

    @Override
    public LinearScale getThis() {
        return this;
    }
    
    @Override
    public JsonObject buildJson() {
        JsonObject map = super.buildJson();
        JUtils.putNotNull(map, "ticks", linearTicks);
        return map;
    }
}
