/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.jopencage.model;

import com.byteowls.jopencage.model.JOpenCageRequest;
import java.util.Map;

public class JOpenCageReverseRequest
extends JOpenCageRequest {
    private Double latitude;
    private Double longitude;
    private String language;
    private boolean noAnnotations;
    private boolean pretty;

    public JOpenCageReverseRequest(Double latitude, Double longitude) {
        if (latitude == null || longitude == null) {
            throw new IllegalArgumentException("Both latitude and longitude must not be null!");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @Override
    public Map<String, String> getParameter() {
        Map<String, String> parameter = super.getParameter();
        parameter.put("query", this.latitude.toString() + " " + this.longitude.toString());
        parameter.put("language", this.language);
        if (this.pretty) {
            parameter.put("pretty", "1");
        }
        if (this.noAnnotations) {
            parameter.put("no_annotations", "1");
        }
        return parameter;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public boolean isNoAnnotations() {
        return this.noAnnotations;
    }

    public void setNoAnnotations(boolean noAnnotations) {
        this.noAnnotations = noAnnotations;
    }
}

