/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.web.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;

public class WbSdkProgressBar
extends View {
    private int miniSize;
    private int paintWidth;
    private int padding;
    private RectF rect;
    private Paint paint;
    private float progress;
    private final int minLength = 20;
    private final int maxLength = 300;
    private float length;
    private long lastTime = 0L;
    private float speed = 200.0f;
    private long stopGrowTimeMax = 180L;
    private long stopGrowTime = 0L;
    private double growTimeMax = 490.0;
    private double growTime;
    private boolean addStart = false;
    private boolean showView = true;
    int stopNum = 0;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    WbSdkProgressBar.this.showView = false;
                }
            }
        }
    };

    public WbSdkProgressBar(Context context) {
        this(context, null);
    }

    public WbSdkProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WbSdkProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.miniSize = this.dip2px(context, 50);
        this.paintWidth = this.dip2px(context, 5);
        this.padding = this.dip2px(context, 3);
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setColor(-48861);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth((float)this.paintWidth);
        this.rect = new RectF((float)this.padding, (float)this.padding, (float)(this.miniSize - this.padding), (float)(this.miniSize - this.padding));
    }

    private int dip2px(Context context, int dip) {
        return (int)(context.getResources().getDisplayMetrics().density * (float)dip);
    }

    protected synchronized void onDraw(Canvas canvas) {
        long middleTime = Math.abs(SystemClock.uptimeMillis() - this.lastTime) % 360L;
        float addProgress = this.speed * (float)middleTime / 1000.0f;
        this.calculateProgress(middleTime);
        this.lastTime = SystemClock.uptimeMillis();
        this.progress += addProgress;
        if (this.progress >= 360.0f) {
            this.progress -= 360.0f;
        }
        canvas.drawArc(this.rect, this.progress - 90.0f, 20.0f + this.length, false, this.paint);
        if (this.showView) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.postInvalidate();
            } else {
                this.invalidate();
            }
        }
    }

    public void setProgressColor(int color) {
        this.paint.setColor(color);
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 8) {
            this.handler.sendEmptyMessageDelayed(0, 1000L);
        } else if (visibility == 0 && this.getVisibility() == 0) {
            this.handler.removeMessages(0);
            this.showView = true;
            this.invalidate();
        }
    }

    private void calculateProgress(long time) {
        if (this.stopGrowTime >= this.stopGrowTimeMax) {
            this.growTime += (double)time;
            if (this.growTime >= this.growTimeMax) {
                this.growTime -= this.growTimeMax;
                this.stopGrowTime = 0L;
                this.addStart = !this.addStart;
            }
            float scale = (float)Math.cos((this.growTime / this.growTimeMax + 1.0) * Math.PI) / 2.0f + 0.5f;
            int middleLength = 280;
            if (!this.addStart) {
                this.length = scale * (float)middleLength;
            } else {
                float newLength = (float)middleLength * (1.0f - scale);
                this.progress += this.length - newLength;
                this.length = newLength;
            }
        } else {
            this.stopGrowTime += time;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.miniSize, this.miniSize);
    }
}

