/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.web.param;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.ImageObject;
import com.sina.weibo.sdk.api.TextObject;
import com.sina.weibo.sdk.api.WebpageObject;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.network.IRequestService;
import com.sina.weibo.sdk.network.impl.RequestParam;
import com.sina.weibo.sdk.network.impl.RequestService;
import com.sina.weibo.sdk.network.target.SimpleTarget;
import com.sina.weibo.sdk.utils.Base64;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.Utility;
import com.sina.weibo.sdk.web.WebPicUploadResult;
import com.sina.weibo.sdk.web.WebRequestType;
import com.sina.weibo.sdk.web.param.BaseWebViewRequestParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ShareWebViewRequestParam
extends BaseWebViewRequestParam {
    public static final String SHARE_URL = "https://service.weibo.com/share/mobilesdk.php";
    private static final String UPLOAD_PIC_URL = "https://service.weibo.com/share/mobilesdk_uppic.php";
    private WeiboMultiMessage multiMessage;
    private String picId;
    private String mShareContent;
    private byte[] mBase64ImgData;
    private String token;
    private String packageName;
    private String hashKey;

    public ShareWebViewRequestParam() {
    }

    public ShareWebViewRequestParam(Context context) {
        this.context = context;
    }

    public ShareWebViewRequestParam(AuthInfo authInfo, WebRequestType type, String callback, String specialTitle, String url, Context context) {
        this(authInfo, type, callback, 0, specialTitle, url, context);
    }

    public ShareWebViewRequestParam(AuthInfo authInfo, WebRequestType type, String callback, int callbackType, String specialTitle, String url, Context context) {
        super(authInfo, type, callback, callbackType, specialTitle, url, context);
    }

    @Override
    public boolean hasExtraTask() {
        if (this.mBase64ImgData != null && this.mBase64ImgData.length > 0) {
            return true;
        }
        return super.hasExtraTask();
    }

    @Override
    public void doExtraTask(final BaseWebViewRequestParam.ExtraTaskCallback callback) {
        super.doExtraTask(callback);
        LogUtil.i("Share", "ShareWebViewRequestParam.doExtraTask()");
        WeiboParameters param = new WeiboParameters(this.getBaseData().getAuthInfo().getAppKey());
        String imgDataBase64Str = new String(this.mBase64ImgData);
        IRequestService requestService = RequestService.getInstance();
        RequestParam.Builder builder = new RequestParam.Builder(this.context);
        builder.setShortUrl(UPLOAD_PIC_URL);
        builder.addPostParam("img", imgDataBase64Str);
        builder.addPostParam("appKey", this.getBaseData().getAuthInfo().getAppKey());
        requestService.asyncRequest(builder.build(), new SimpleTarget(){

            @Override
            public void onSuccess(String response) {
                LogUtil.i("Share", "ShareWebViewRequestParam.doExtraTask().onSuccess()");
                WebPicUploadResult result = WebPicUploadResult.parse(response);
                if (result != null && result.getCode() == 1 && !TextUtils.isEmpty((CharSequence)result.getPicId())) {
                    ShareWebViewRequestParam.this.picId = result.getPicId();
                    if (callback != null) {
                        callback.onComplete(ShareWebViewRequestParam.this.picId);
                    }
                } else if (callback != null) {
                    callback.onException("upload pic fail");
                }
            }

            @Override
            public void onFailure(Exception e) {
                LogUtil.i("Share", "ShareWebViewRequestParam.doExtraTask().onFailure(),e =" + e.getMessage());
                if (callback != null) {
                    callback.onException("upload pic fail");
                }
            }
        });
    }

    @Override
    protected void childFillBundle(Bundle bundle) {
        if (this.multiMessage != null) {
            this.multiMessage.toBundle(bundle);
        }
        bundle.putString("token", this.token);
        bundle.putString("packageName", this.packageName);
        bundle.putString("hashKey", this.hashKey);
    }

    @Override
    protected void transformChildBundle(Bundle bundle) {
        this.multiMessage = new WeiboMultiMessage();
        this.multiMessage.toObject(bundle);
        this.token = bundle.getString("token");
        this.packageName = bundle.getString("packageName");
        this.hashKey = bundle.getString("hashKey");
        this.getBaseUrl();
    }

    @Override
    public String getRequestUrl() {
        String aid;
        String appKey = this.getBaseData().getAuthInfo().getAppKey();
        Uri uri = Uri.parse((String)SHARE_URL);
        Uri.Builder builder = uri.buildUpon();
        builder.appendQueryParameter("title", this.mShareContent);
        builder.appendQueryParameter("version", "0041005000");
        if (!TextUtils.isEmpty((CharSequence)appKey)) {
            builder.appendQueryParameter("source", appKey);
        }
        if (!TextUtils.isEmpty((CharSequence)this.token)) {
            builder.appendQueryParameter("access_token", this.token);
        }
        if (this.context != null && !TextUtils.isEmpty((CharSequence)(aid = Utility.getAid(this.context, appKey)))) {
            builder.appendQueryParameter("aid", aid);
        }
        if (!TextUtils.isEmpty((CharSequence)this.packageName)) {
            builder.appendQueryParameter("packagename", this.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)this.hashKey)) {
            builder.appendQueryParameter("key_hash", this.hashKey);
        }
        if (!TextUtils.isEmpty((CharSequence)this.picId)) {
            builder.appendQueryParameter("picinfo", this.picId);
        }
        builder.appendQueryParameter("luicode", "10000360");
        builder.appendQueryParameter("lfid", "OP_" + appKey);
        return builder.build().toString();
    }

    @Override
    public void updateRequestUrl(String url) {
        this.picId = url;
    }

    public void setMultiMessage(WeiboMultiMessage message) {
        this.multiMessage = message;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setHashKey(String hashKey) {
        this.hashKey = hashKey;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private void getBaseUrl() {
        StringBuilder content = new StringBuilder();
        if (this.multiMessage.textObject instanceof TextObject) {
            TextObject textObject = this.multiMessage.textObject;
            content.append(textObject.text + " ");
        }
        if (this.multiMessage.mediaObject != null && this.multiMessage.mediaObject instanceof WebpageObject && !TextUtils.isEmpty((CharSequence)this.multiMessage.mediaObject.actionUrl)) {
            content.append(this.multiMessage.mediaObject.actionUrl);
        }
        if (this.multiMessage.imageObject instanceof ImageObject) {
            ImageObject imageObject = this.multiMessage.imageObject;
            this.handleMblogPic(imageObject.imagePath, imageObject.imageData);
        }
        this.mShareContent = content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMblogPic(String picPath, byte[] thumbData) {
        block15: {
            try {
                File picFile;
                if (TextUtils.isEmpty((CharSequence)picPath) || !(picFile = new File(picPath)).exists() || !picFile.canRead() || picFile.length() <= 0L) break block15;
                byte[] tmpPic = new byte[(int)picFile.length()];
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(picFile);
                    fis.read(tmpPic);
                    this.mBase64ImgData = Base64.encodebyte(tmpPic);
                    return;
                }
                catch (IOException e) {
                    tmpPic = null;
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (thumbData != null && thumbData.length > 0) {
            this.mBase64ImgData = Base64.encodebyte(thumbData);
        }
    }
}

