/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.web.param;

import android.content.Context;
import android.os.Bundle;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.web.BaseWebViewRequestData;
import com.sina.weibo.sdk.web.WebRequestType;
import java.io.Serializable;

public abstract class BaseWebViewRequestParam {
    private BaseWebViewRequestData baseData;
    protected Context context;
    private String transaction;

    public BaseWebViewRequestParam() {
    }

    public BaseWebViewRequestParam(AuthInfo authInfo, WebRequestType type, String callback, String specialTitle, String url, Context context) {
        this(authInfo, type, callback, 0, specialTitle, url, context);
    }

    public BaseWebViewRequestParam(AuthInfo authInfo, WebRequestType type, String callback, int callbackType, String specialTitle, String url, Context context) {
        this.baseData = new BaseWebViewRequestData(authInfo, type, callback, callbackType, specialTitle, url);
        this.context = context;
        this.transaction = String.valueOf(System.currentTimeMillis());
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public Bundle fillBundle(Bundle bundle) {
        if (this.baseData == null) {
            throw new NullPointerException("\u6784\u9020\u65b9\u6cd5\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u5168\u53c2\u6570\u7684\u6784\u9020\u65b9\u6cd5\u6784\u5efa");
        }
        bundle.putSerializable("base", (Serializable)this.baseData);
        switch (this.baseData.getType()) {
            case DEFAULT: {
                bundle.putInt("type", 0);
                break;
            }
            case SHARE: {
                bundle.putInt("type", 1);
                break;
            }
            case AUTH: {
                bundle.putInt("type", 2);
            }
        }
        bundle.putString("_weibo_transaction", this.transaction);
        this.childFillBundle(bundle);
        return bundle;
    }

    protected abstract void childFillBundle(Bundle var1);

    public void transformBundle(Bundle bundle) {
        this.baseData = (BaseWebViewRequestData)bundle.getSerializable("base");
        this.transaction = bundle.getString("_weibo_transaction");
        this.transformChildBundle(bundle);
    }

    protected abstract void transformChildBundle(Bundle var1);

    public boolean hasExtraTask() {
        return false;
    }

    public void doExtraTask(ExtraTaskCallback callback) {
    }

    public BaseWebViewRequestData getBaseData() {
        return this.baseData;
    }

    public abstract String getRequestUrl();

    public abstract void updateRequestUrl(String var1);

    public static interface ExtraTaskCallback {
        public void onComplete(String var1);

        public void onException(String var1);
    }
}

