/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.web.client;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.WbUtils;
import com.sina.weibo.sdk.web.WebViewRequestCallback;
import com.sina.weibo.sdk.web.WeiboCallbackManager;
import com.sina.weibo.sdk.web.client.BaseWebViewClient;
import com.sina.weibo.sdk.web.param.BaseWebViewRequestParam;

public class ShareWebViewClient
extends BaseWebViewClient {
    private static final String RESP_SUCC_CODE = "0";
    private static final String RESP_PARAM_CODE = "code";
    private static final String RESP_PARAM_MSG = "msg";
    private Activity activity;
    private boolean hasCallbacked = false;

    public ShareWebViewClient(Activity activity, WebViewRequestCallback callback, BaseWebViewRequestParam param) {
        super(callback, param);
        this.activity = activity;
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        if (this.requestCallback != null) {
            this.requestCallback.onPageStartedCallBack(view, url, favicon);
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (this.requestCallback != null) {
            this.requestCallback.onPageFinishedCallBack(view, url);
        }
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        if (this.requestCallback != null) {
            this.requestCallback.onReceivedErrorCallBack(view, error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        if (this.requestCallback != null) {
            this.requestCallback.onReceivedErrorCallBack(view, errorCode, description, failingUrl);
        }
    }

    @Override
    @TargetApi(value=24)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        return this.needOverLoad(request.getUrl().toString());
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (this.requestCallback != null) {
            this.requestCallback.shouldOverrideUrlLoadingCallBack(view, url);
        }
        return this.needOverLoad(url);
    }

    private boolean needOverLoad(String url) {
        if (url.startsWith("sinaweibo://browser/close")) {
            Bundle bundle = WbUtils.parseUri(url);
            if (this.param.getBaseData() != null && !TextUtils.isEmpty((CharSequence)this.param.getBaseData().getCallback())) {
                String callbackKey = this.param.getBaseData().getCallback();
                WeiboCallbackManager manager = WeiboCallbackManager.getInstance();
                if (manager.getWeiboAuthListener(callbackKey) != null && !bundle.isEmpty()) {
                    manager.removeWeiboAuthListener(callbackKey);
                }
            }
            String errCode = bundle.getString(RESP_PARAM_CODE);
            String errMsg = bundle.getString(RESP_PARAM_MSG);
            if (TextUtils.isEmpty((CharSequence)errCode)) {
                this.sendSdkCancleResponse(this.activity);
            } else if (!RESP_SUCC_CODE.equals(errCode)) {
                this.sendSdkErrorResponse(this.activity, errMsg);
            } else {
                this.sendSdkOkResponse(this.activity);
            }
            if (this.requestCallback != null) {
                this.requestCallback.closePage();
            }
            return true;
        }
        return false;
    }

    private void sendSdkResponse(Activity activity, int errCode, String errMsg) {
        LogUtil.i("Share", "WebActivity.sendSdkResponse,errCode:" + errCode + ",errMsg:" + errMsg);
        Bundle bundle = activity.getIntent().getExtras();
        if (bundle == null || this.hasCallbacked) {
            return;
        }
        Intent intent = new Intent("com.sina.weibo.sdk.action.ACTION_SDK_REQ_ACTIVITY");
        String packageName = bundle.getString("packageName");
        intent.setFlags(131072);
        intent.setPackage(packageName);
        intent.putExtras(bundle);
        intent.putExtra("_weibo_appPackage", activity.getPackageName());
        intent.putExtra("_weibo_resp_errcode", errCode);
        intent.putExtra("_weibo_resp_errstr", errMsg);
        try {
            activity.startActivityForResult(intent, 765);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
        this.hasCallbacked = true;
    }

    public void sendSdkCancleResponse(Activity activity) {
        this.sendSdkResponse(activity, 1, "send cancel!!!");
    }

    public void sendSdkOkResponse(Activity activity) {
        this.sendSdkResponse(activity, 0, "send ok!!!");
    }

    public void sendSdkErrorResponse(Activity activity, String msg) {
        this.sendSdkResponse(activity, 2, msg);
    }

    @Override
    public void errorBack(Activity activity, String msg) {
        super.errorBack(activity, msg);
        this.sendSdkErrorResponse(activity, msg);
    }

    @Override
    public void closeWeb() {
        super.closeWeb();
        this.sendSdkCancleResponse(this.activity);
    }

    @Override
    public boolean onBackKeyDown() {
        this.closeWeb();
        if (this.requestCallback != null) {
            this.requestCallback.closePage();
        }
        return true;
    }
}

