/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.web.client;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import com.sina.weibo.sdk.auth.AccessTokenKeeper;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.auth.WbAuthListener;
import com.sina.weibo.sdk.auth.WbConnectErrorMessage;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.Utility;
import com.sina.weibo.sdk.web.WebViewRequestCallback;
import com.sina.weibo.sdk.web.WeiboCallbackManager;
import com.sina.weibo.sdk.web.client.BaseWebViewClient;
import com.sina.weibo.sdk.web.param.BaseWebViewRequestParam;

public class AuthWebViewClient
extends BaseWebViewClient {
    private static final String TAG = "AuthWebViewClient";
    private Context context;
    private boolean authed = false;

    public AuthWebViewClient(WebViewRequestCallback callback, Context context, BaseWebViewRequestParam param) {
        super(callback, param);
        this.context = context;
    }

    @Override
    @TargetApi(value=24)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        LogUtil.d(TAG, "shouldOverrideUrlLoading,request.getUrl()");
        String url = request.getUrl().toString();
        return this.needOverLoad(view, url);
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        LogUtil.d(TAG, "shouldOverrideUrlLoading,url");
        return this.needOverLoad(view, url);
    }

    private boolean needOverLoad(WebView view, String url) {
        if (url.startsWith("sms:")) {
            try {
                Intent sendIntent = new Intent("android.intent.action.VIEW");
                sendIntent.putExtra("address", url.replace("sms:", ""));
                sendIntent.setType("vnd.android-dir/mms-sms");
                this.context.startActivity(sendIntent);
                return true;
            }
            catch (Exception sendIntent) {}
        } else {
            Bundle data;
            String value;
            if (url.startsWith("sinaweibo://browser/close")) {
                if (this.param.getBaseData() != null && !TextUtils.isEmpty((CharSequence)this.param.getBaseData().getCallback())) {
                    String callbackKey = this.param.getBaseData().getCallback();
                    WeiboCallbackManager manager = WeiboCallbackManager.getInstance();
                    if (manager.getWeiboAuthListener(callbackKey) != null) {
                        manager.getWeiboAuthListener(callbackKey).cancel();
                    }
                    manager.removeWeiboAuthListener(callbackKey);
                }
                return true;
            }
            if (this.isMatchWithRedirectUrl(url) && !TextUtils.isEmpty((CharSequence)(value = (data = Utility.parseUrl(url)).getString("access_token")))) {
                return true;
            }
        }
        return false;
    }

    private boolean isMatchWithRedirectUrl(String url) {
        String redirectUrl = this.param.getBaseData().getAuthInfo().getRedirectUrl();
        Uri redirectUri = Uri.parse((String)redirectUrl);
        Uri uri = Uri.parse((String)url);
        String redirectHost = redirectUri.getHost();
        return !TextUtils.isEmpty((CharSequence)redirectHost) && redirectHost.equals(uri.getHost());
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        LogUtil.d(TAG, "onPageStarted:");
        if (this.requestCallback != null) {
            this.requestCallback.onPageStartedCallBack(view, url, favicon);
        }
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView view, String url) {
        LogUtil.d(TAG, "onPageFinished:");
        super.onPageFinished(view, url);
        if (this.requestCallback != null) {
            this.requestCallback.onPageFinishedCallBack(view, url);
        }
        if (this.isMatchWithRedirectUrl(url) && !this.authed) {
            this.authed = true;
            this.handleRedirectUrl(url);
            view.stopLoading();
            if (this.requestCallback != null) {
                this.requestCallback.closePage();
            }
        }
    }

    @TargetApi(value=24)
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        LogUtil.d(TAG, "onReceivedError");
        if (this.requestCallback != null) {
            this.requestCallback.onReceivedErrorCallBack(view, error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        LogUtil.d(TAG, "onReceivedError");
        if (this.requestCallback != null) {
            this.requestCallback.onReceivedErrorCallBack(view, errorCode, description, failingUrl);
        }
    }

    private void handleRedirectUrl(String url) {
        Bundle values = Utility.parseUrl(url);
        String errorType = values.getString("error");
        String errorCode = values.getString("error_code");
        String errorDescription = values.getString("error_description");
        WbAuthListener mListener = null;
        if (this.param.getBaseData() != null && !TextUtils.isEmpty((CharSequence)this.param.getBaseData().getCallback())) {
            String callbackKey = this.param.getBaseData().getCallback();
            WeiboCallbackManager manager = WeiboCallbackManager.getInstance();
            mListener = manager.getWeiboAuthListener(callbackKey);
            manager.removeWeiboAuthListener(callbackKey);
        }
        if (null == errorType && null == errorCode) {
            if (mListener != null) {
                Oauth2AccessToken newToken = Oauth2AccessToken.parseAccessToken(values);
                AccessTokenKeeper.writeAccessToken(this.context, newToken);
                mListener.onSuccess(newToken);
            }
        } else if (mListener != null) {
            mListener.onFailure(new WbConnectErrorMessage(errorCode, errorDescription));
        }
    }

    @Override
    public void closeWeb() {
        super.closeWeb();
        if (this.param.getBaseData() != null && !TextUtils.isEmpty((CharSequence)this.param.getBaseData().getCallback())) {
            String callbackKey = this.param.getBaseData().getCallback();
            WeiboCallbackManager manager = WeiboCallbackManager.getInstance();
            if (manager.getWeiboAuthListener(callbackKey) != null) {
                manager.getWeiboAuthListener(callbackKey).cancel();
            }
            manager.removeWeiboAuthListener(callbackKey);
        }
    }

    @Override
    public boolean onBackKeyDown() {
        this.closeWeb();
        if (this.requestCallback != null) {
            this.requestCallback.closePage();
        }
        return true;
    }
}

