/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.web;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.ResourceManager;
import com.sina.weibo.sdk.utils.UIUtils;
import com.sina.weibo.sdk.utils.WbUtils;
import com.sina.weibo.sdk.web.WebViewRequestCallback;
import com.sina.weibo.sdk.web.client.AuthWebViewClient;
import com.sina.weibo.sdk.web.client.BaseWebViewClient;
import com.sina.weibo.sdk.web.client.DefaultWebViewClient;
import com.sina.weibo.sdk.web.client.ShareWebViewClient;
import com.sina.weibo.sdk.web.param.AuthWebViewRequestParam;
import com.sina.weibo.sdk.web.param.BaseWebViewRequestParam;
import com.sina.weibo.sdk.web.param.DefaultWebViewRequestParam;
import com.sina.weibo.sdk.web.param.ShareWebViewRequestParam;
import com.sina.weibo.sdk.web.view.LoadingBar;
import java.lang.reflect.Method;

public class WeiboSdkWebActivity
extends Activity
implements WebViewRequestCallback {
    private static final String CANCEL_EN = "Close";
    private static final String CANCEL_ZH_CN = "\u5173\u95ed";
    private static final String CANCEL_ZH_TW = "\u5173\u95ed";
    private static final String EMPTY_PROMPT_BAD_NETWORK_UI_EN = "A network error occurs, please tap the button to reload";
    private static final String EMPTY_PROMPT_BAD_NETWORK_UI_ZH_CN = "\u7f51\u7edc\u51fa\u9519\u5566\uff0c\u8bf7\u70b9\u51fb\u6309\u94ae\u91cd\u65b0\u52a0\u8f7d";
    private static final String EMPTY_PROMPT_BAD_NETWORK_UI_ZH_TW = "\u7db2\u8def\u51fa\u932f\u5566\uff0c\u8acb\u9ede\u64ca\u6309\u9215\u91cd\u65b0\u8f09\u5165";
    private static final String CHANNEL_DATA_ERROR_EN = "channel_data_error";
    private static final String CHANNEL_DATA_ERROR_ZH_CN = "\u91cd\u65b0\u52a0\u8f7d";
    private static final String CHANNEL_DATA_ERROR_ZH_TW = "\u91cd\u65b0\u8f09\u5165";
    private static final String WEIBOBROWSER_NO_TITLE_EN = "No Title";
    private static final String WEIBOBROWSER_NO_TITLE_ZH_CN = "\u65e0\u6807\u9898";
    private static final String WEIBOBROWSER_NO_TITLE_ZH_TW = "\u7121\u6a19\u984c";
    private static final String LOADINFO_EN = "Loading....";
    private static final String LOADINFO_ZH_CN = "\u52a0\u8f7d\u4e2d....";
    private static final String LOADINFO_ZH_TW = "\u8f09\u5165\u4e2d....";
    public static final String BROWSER_CLOSE_SCHEME = "sinaweibo://browser/close";
    private TextView leftBtn;
    private TextView titleText;
    private WebView webView;
    private LoadingBar loadingBar;
    private Button retryBtn;
    private TextView retryTitle;
    private LinearLayout retryLayout;
    private BaseWebViewRequestParam baseParam;
    private BaseWebViewClient webViewClient;
    private int pageStatus = 0;

    protected void onCreate(Bundle savedInstanceState) {
        LogUtil.i("Share", "startWebActivity");
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(this.initView());
        this.initLoad();
    }

    private void initLoad() {
        LogUtil.i("Share", "WebActivity.initLoad().start");
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            this.finish();
            return;
        }
        int type = bundle.getInt("type", -1);
        if (type == -1) {
            this.finish();
            return;
        }
        switch (type) {
            case 0: {
                this.baseParam = new DefaultWebViewRequestParam();
                this.webViewClient = new DefaultWebViewClient(this, this.baseParam);
                break;
            }
            case 1: {
                this.baseParam = new ShareWebViewRequestParam((Context)this);
                this.webViewClient = new ShareWebViewClient(this, this, this.baseParam);
                break;
            }
            case 2: {
                this.baseParam = new AuthWebViewRequestParam();
                this.webViewClient = new AuthWebViewClient(this, (Context)this, this.baseParam);
            }
        }
        this.webView.setWebViewClient((WebViewClient)this.webViewClient);
        this.baseParam.transformBundle(bundle);
        this.initWebView();
        if (this.baseParam.hasExtraTask()) {
            this.baseParam.doExtraTask(new BaseWebViewRequestParam.ExtraTaskCallback(){

                @Override
                public void onComplete(String urlTask) {
                    LogUtil.i("Share", "WebActivity.sharePic.onComplete()");
                    if (WeiboSdkWebActivity.this.checkRequestUrl(WeiboSdkWebActivity.this.baseParam.getRequestUrl())) {
                        WeiboSdkWebActivity.this.webView.loadUrl(WeiboSdkWebActivity.this.baseParam.getRequestUrl());
                    }
                }

                @Override
                public void onException(String errorMsg) {
                    LogUtil.i("Share", "WebActivity.sharePic.onException()");
                    WeiboSdkWebActivity.this.webViewClient.errorBack(WeiboSdkWebActivity.this, "pic upload error");
                    WeiboSdkWebActivity.this.finish();
                }
            });
        } else {
            String url = this.baseParam.getRequestUrl();
            if (this.checkRequestUrl(url)) {
                this.webView.loadUrl(url);
            }
        }
        LogUtil.i("Share", "WebActivity.initLoad().end");
    }

    private boolean checkRequestUrl(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && (url.startsWith("https://service.weibo.com/share/mobilesdk.php") || url.startsWith("https://open.weibo.cn/oauth2/authorize?"));
    }

    private View initView() {
        RelativeLayout rootView = new RelativeLayout((Context)this);
        rootView.setBackgroundColor(-1);
        RelativeLayout titleLayout = new RelativeLayout((Context)this);
        this.leftBtn = new TextView((Context)this);
        this.leftBtn.setTextSize(17.0f);
        this.leftBtn.setTextColor(ResourceManager.createColorStateList(-32256, 1728020992));
        this.leftBtn.setText((CharSequence)ResourceManager.getString((Context)this, CANCEL_EN, "\u5173\u95ed", "\u5173\u95ed"));
        this.leftBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WeiboSdkWebActivity.this.webViewClient.closeWeb();
                WeiboSdkWebActivity.this.closeActivity();
            }
        });
        this.titleText = new TextView((Context)this);
        this.titleText.setTextSize(18.0f);
        this.titleText.setTextColor(-11382190);
        RelativeLayout.LayoutParams leftParam = new RelativeLayout.LayoutParams(-2, -2);
        RelativeLayout.LayoutParams titleParam = new RelativeLayout.LayoutParams(-2, -2);
        leftParam.addRule(15);
        this.leftBtn.setPadding(UIUtils.dip2px(10, (Context)this), 0, UIUtils.dip2px(10, (Context)this), 0);
        titleParam.addRule(13);
        titleLayout.addView((View)this.leftBtn, (ViewGroup.LayoutParams)leftParam);
        titleLayout.addView((View)this.titleText, (ViewGroup.LayoutParams)titleParam);
        RelativeLayout.LayoutParams titleLayoutParam = new RelativeLayout.LayoutParams(-1, UIUtils.dip2px(55, (Context)this));
        rootView.addView((View)titleLayout, (ViewGroup.LayoutParams)titleLayoutParam);
        this.webView = new WebView(this.getApplicationContext());
        this.webView.getSettings().setSavePassword(false);
        this.webView.getSettings().setAllowFileAccess(false);
        this.webView.getSettings().setAllowContentAccess(false);
        RelativeLayout.LayoutParams webParam = new RelativeLayout.LayoutParams(-1, -1);
        webParam.topMargin = UIUtils.dip2px(55, (Context)this);
        rootView.addView((View)this.webView, (ViewGroup.LayoutParams)webParam);
        this.loadingBar = new LoadingBar((Context)this);
        RelativeLayout.LayoutParams loadParam = new RelativeLayout.LayoutParams(-1, UIUtils.dip2px(3, (Context)this));
        loadParam.topMargin = UIUtils.dip2px(55, (Context)this);
        rootView.addView((View)this.loadingBar, (ViewGroup.LayoutParams)loadParam);
        View loadTitleView = new View((Context)this);
        loadTitleView.setBackgroundResource(this.getResources().getIdentifier("weibosdk_common_shadow_top", "drawable", this.getPackageName()));
        RelativeLayout.LayoutParams loadShadowParam = new RelativeLayout.LayoutParams(-1, UIUtils.dip2px(3, (Context)this));
        loadShadowParam.topMargin = UIUtils.dip2px(55, (Context)this);
        rootView.addView(loadTitleView, (ViewGroup.LayoutParams)loadShadowParam);
        this.retryLayout = new LinearLayout((Context)this);
        this.retryLayout.setOrientation(1);
        ImageView retryImage = new ImageView((Context)this);
        retryImage.setImageResource(this.getResources().getIdentifier("weibosdk_empty_failed", "drawable", this.getPackageName()));
        this.retryLayout.addView((View)retryImage);
        this.retryTitle = new TextView((Context)this);
        this.retryTitle.setTextSize(14.0f);
        this.retryTitle.setTextColor(-4342339);
        LinearLayout.LayoutParams retryTextParam = new LinearLayout.LayoutParams(-2, -2);
        retryTextParam.topMargin = UIUtils.dip2px(18, (Context)this);
        retryTextParam.bottomMargin = UIUtils.dip2px(20, (Context)this);
        this.retryLayout.addView((View)this.retryTitle, (ViewGroup.LayoutParams)retryTextParam);
        this.retryBtn = new Button((Context)this);
        this.retryBtn.setTextSize(16.0f);
        this.retryBtn.setTextColor(-8882056);
        LinearLayout.LayoutParams retryBtnParam = new LinearLayout.LayoutParams(UIUtils.dip2px(142, (Context)this), UIUtils.dip2px(46, (Context)this));
        retryBtnParam.gravity = 17;
        this.retryLayout.addView((View)this.retryBtn, (ViewGroup.LayoutParams)retryBtnParam);
        this.retryBtn.setBackgroundResource(this.getResources().getIdentifier("retry_btn_selector", "drawable", this.getPackageName()));
        RelativeLayout.LayoutParams retryLayoutParam = new RelativeLayout.LayoutParams(-2, -2);
        retryLayoutParam.addRule(13);
        rootView.addView((View)this.retryLayout, (ViewGroup.LayoutParams)retryLayoutParam);
        this.retryLayout.setVisibility(8);
        this.webView.setWebChromeClient((WebChromeClient)new MyChromeClient());
        this.retryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WeiboSdkWebActivity.this.pageStatus = 0;
                WeiboSdkWebActivity.this.showDefaultPage();
                WeiboSdkWebActivity.this.webView.reload();
            }
        });
        this.retryTitle.setText((CharSequence)ResourceManager.getString((Context)this, EMPTY_PROMPT_BAD_NETWORK_UI_EN, EMPTY_PROMPT_BAD_NETWORK_UI_ZH_CN, EMPTY_PROMPT_BAD_NETWORK_UI_ZH_TW));
        this.retryBtn.setText((CharSequence)ResourceManager.getString((Context)this, CHANNEL_DATA_ERROR_EN, CHANNEL_DATA_ERROR_ZH_CN, CHANNEL_DATA_ERROR_ZH_TW));
        return rootView;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView() {
        if (!TextUtils.isEmpty((CharSequence)this.baseParam.getBaseData().getSpecifyTitle())) {
            this.titleText.setText((CharSequence)this.baseParam.getBaseData().getSpecifyTitle());
        }
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setSavePassword(false);
        this.webView.getSettings().setUserAgentString(WbUtils.generateUA((Context)this, this.baseParam.getBaseData().getAuthInfo().getAppKey()));
        this.webView.requestFocus();
        this.webView.setScrollBarStyle(0);
        WeiboSdkWebActivity.removeJavascriptInterface(this.webView, "searchBoxJavaBridge_");
        WeiboSdkWebActivity.removeJavascriptInterface(this.webView, "accessibility");
        WeiboSdkWebActivity.removeJavascriptInterface(this.webView, "accessibilityTraversal");
        if (Build.VERSION.SDK_INT >= 21) {
            this.webView.getSettings().setMixedContentMode(2);
        }
    }

    public static void removeJavascriptInterface(WebView webView, String string) {
        try {
            Method removeMethod = WebView.class.getDeclaredMethod("removeJavascriptInterface", String.class);
            removeMethod.invoke((Object)webView, string);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeActivity() {
        this.finish();
    }

    private void showErrorPage() {
        this.retryLayout.setVisibility(0);
        this.webView.setVisibility(8);
    }

    private void showDefaultPage() {
        this.retryLayout.setVisibility(8);
        this.webView.setVisibility(0);
    }

    @Override
    public void onPageStartedCallBack(WebView view, String url, Bitmap favicon) {
    }

    @Override
    public void onPageFinishedCallBack(WebView view, String url) {
        if (this.pageStatus == -1) {
            this.showErrorPage();
        } else {
            this.showDefaultPage();
        }
    }

    @Override
    public boolean shouldOverrideUrlLoadingCallBack(WebView view, String url) {
        return false;
    }

    @Override
    public void onReceivedErrorCallBack(WebView view, int errorCode, String description, String failingUrl) {
        String url = view.getUrl();
        try {
            if (!TextUtils.isEmpty((CharSequence)url) && !TextUtils.isEmpty((CharSequence)failingUrl)) {
                Uri loadUri = Uri.parse((String)url);
                Uri failUri = Uri.parse((String)failingUrl);
                if (loadUri.getHost().equals(failUri.getHost()) && loadUri.getScheme().equals(failUri.getScheme())) {
                    this.pageStatus = -1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onReceivedSslErrorCallBack(WebView view, final SslErrorHandler handler, SslError error) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"\u8b66\u544a");
        builder.setMessage((CharSequence)"\u4f60\u8bbf\u95ee\u7684\u8fde\u63a5\u53ef\u80fd\u5b58\u5728\u9690\u60a3\uff0c\u662f\u5426\u7ee7\u7eed\u8bbf\u95ee");
        builder.setPositiveButton((CharSequence)"\u7ee7\u7eed", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                handler.proceed();
            }
        });
        builder.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                handler.cancel();
            }
        });
        builder.create().show();
    }

    @Override
    public void closePage() {
        this.finish();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.webViewClient.onBackKeyDown()) {
                return true;
            }
            if (this.webView.canGoBack()) {
                this.webView.goBack();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private class MyChromeClient
    extends WebChromeClient {
        private MyChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            WeiboSdkWebActivity.this.loadingBar.drawProgress(newProgress);
            if (newProgress == 100) {
                WeiboSdkWebActivity.this.loadingBar.setVisibility(4);
            } else {
                WeiboSdkWebActivity.this.loadingBar.setVisibility(0);
            }
        }

        public void onReceivedTitle(WebView view, String title) {
            super.onReceivedTitle(view, title);
            if (TextUtils.isEmpty((CharSequence)WeiboSdkWebActivity.this.baseParam.getBaseData().getSpecifyTitle())) {
                WeiboSdkWebActivity.this.titleText.setText((CharSequence)title);
            }
        }
    }
}

