/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.web;

import android.text.TextUtils;
import com.sina.weibo.sdk.auth.WbAuthListener;
import java.util.HashMap;
import java.util.Map;

public class WeiboCallbackManager {
    private static WeiboCallbackManager sInstance;
    private Map<String, WbAuthListener> mWeiboAuthListenerMap = new HashMap<String, WbAuthListener>();

    private WeiboCallbackManager() {
    }

    public static synchronized WeiboCallbackManager getInstance() {
        if (sInstance == null) {
            sInstance = new WeiboCallbackManager();
        }
        return sInstance;
    }

    public synchronized WbAuthListener getWeiboAuthListener(String callbackId) {
        if (TextUtils.isEmpty((CharSequence)callbackId)) {
            return null;
        }
        return this.mWeiboAuthListenerMap.get(callbackId);
    }

    public synchronized void setWeiboAuthListener(String callbackId, WbAuthListener authListener) {
        if (TextUtils.isEmpty((CharSequence)callbackId) || authListener == null) {
            return;
        }
        this.mWeiboAuthListenerMap.put(callbackId, authListener);
    }

    public synchronized void removeWeiboAuthListener(String callbackId) {
        if (TextUtils.isEmpty((CharSequence)callbackId)) {
            return;
        }
        this.mWeiboAuthListenerMap.remove(callbackId);
    }

    public String genCallbackKey() {
        return String.valueOf(System.currentTimeMillis());
    }
}

