/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.web;

import android.os.Parcel;
import android.os.Parcelable;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.web.WebRequestType;
import java.io.Serializable;

public class BaseWebViewRequestData
implements Parcelable,
Serializable {
    private String url;
    private AuthInfo authInfo;
    private WebRequestType type;
    private String callback;
    private String specifyTitle;
    private int callbackType = 0;
    public static final Parcelable.Creator<BaseWebViewRequestData> CREATOR = new Parcelable.Creator<BaseWebViewRequestData>(){

        public BaseWebViewRequestData createFromParcel(Parcel source) {
            return new BaseWebViewRequestData(source);
        }

        public BaseWebViewRequestData[] newArray(int size) {
            return new BaseWebViewRequestData[size];
        }
    };

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public String getCallback() {
        return this.callback;
    }

    public BaseWebViewRequestData(AuthInfo info, WebRequestType type, String callback, String specifyTitle, String url) {
        this(info, type, callback, 0, specifyTitle, url);
    }

    public BaseWebViewRequestData(AuthInfo info, WebRequestType type, String callback, int callbackType, String specifyTitle, String url) {
        this.callback = callback;
        this.authInfo = info;
        this.type = type;
        this.specifyTitle = specifyTitle;
        this.url = url;
        this.callbackType = callbackType;
    }

    public int getCallbackType() {
        return this.callbackType;
    }

    public void setCallbackType(int callbackType) {
        this.callbackType = callbackType;
    }

    public String getSpecifyTitle() {
        return this.specifyTitle;
    }

    public void setSpecifyTitle(String specifyTitle) {
        this.specifyTitle = specifyTitle;
    }

    public String getUrl() {
        return this.url;
    }

    public AuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public WebRequestType getType() {
        return this.type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAuthInfo(AuthInfo authInfo) {
        this.authInfo = authInfo;
    }

    public void setType(WebRequestType type) {
        this.type = type;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.url);
        dest.writeParcelable((Parcelable)this.authInfo, flags);
        dest.writeInt(this.type == null ? -1 : this.type.ordinal());
        dest.writeString(this.callback);
        dest.writeString(this.specifyTitle);
        dest.writeInt(this.callbackType);
    }

    protected BaseWebViewRequestData(Parcel in) {
        this.url = in.readString();
        this.authInfo = (AuthInfo)in.readParcelable(AuthInfo.class.getClassLoader());
        int tmpType = in.readInt();
        this.type = tmpType == -1 ? null : WebRequestType.values()[tmpType];
        this.callback = in.readString();
        this.specifyTitle = in.readString();
        this.callbackType = in.readInt();
    }
}

