/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;

public class WbUtils {
    private static final String WEIBO_IDENTITY_ACTION = "com.sina.weibo.action.sdkidentity";
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static Bundle parseUri(String uri) {
        try {
            URI u = new URI(uri);
            Bundle b = WbUtils.decodeUrl(u.getQuery());
            return b;
        }
        catch (Exception e) {
            return new Bundle();
        }
    }

    public static Bundle decodeUrl(String s) {
        Bundle params = new Bundle();
        if (s != null) {
            String[] array;
            for (String parameter : array = s.split("&")) {
                String[] v = parameter.split("=");
                try {
                    params.putString(URLDecoder.decode(v[0], DEFAULT_CHARSET), URLDecoder.decode(v[1], DEFAULT_CHARSET));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return params;
    }

    public static String generateUA(Context ctx, String appkey) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Build.MANUFACTURER).append("-").append(Build.MODEL);
        buffer.append("_");
        buffer.append(Build.VERSION.RELEASE);
        buffer.append("_");
        buffer.append("weibosdk");
        buffer.append("_");
        buffer.append("0041005000");
        buffer.append("_android");
        return buffer.toString();
    }

    public static boolean isWeiboInstall(Context context) {
        Intent intent = new Intent(WEIBO_IDENTITY_ACTION);
        intent.addCategory("android.intent.category.DEFAULT");
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        return list != null && !list.isEmpty();
    }

    public static boolean supportMixtureShare() {
        return true;
    }
}

