/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.sso.WeiboSsoManager;
import com.sina.weibo.sdk.utils.MD5;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.UUID;

public class Utility {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static Bundle parseUrl(String url) {
        try {
            URL u = new URL(url);
            Bundle b = Utility.decodeUrl(u.getQuery());
            b.putAll(Utility.decodeUrl(u.getRef()));
            return b;
        }
        catch (MalformedURLException e) {
            return new Bundle();
        }
    }

    public static Bundle decodeUrl(String s) {
        Bundle params = new Bundle();
        if (s != null) {
            String[] array;
            for (String parameter : array = s.split("&")) {
                String[] v = parameter.split("=");
                try {
                    if (v.length == 2) {
                        params.putString(URLDecoder.decode(v[0], DEFAULT_CHARSET), URLDecoder.decode(v[1], DEFAULT_CHARSET));
                        continue;
                    }
                    if (v.length != 1) continue;
                    params.putString(URLDecoder.decode(v[0], DEFAULT_CHARSET), "");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return params;
    }

    public static boolean isChineseLocale(Context context) {
        try {
            Locale locale = context.getResources().getConfiguration().locale;
            if (Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale) || Locale.SIMPLIFIED_CHINESE.equals(locale) || Locale.TAIWAN.equals(locale)) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public static String generateGUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getSign(Context context, String pkgName) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(pkgName, 64);
            for (int j = 0; j < packageInfo.signatures.length; ++j) {
                byte[] str = packageInfo.signatures[j].toByteArray();
                if (str == null) continue;
                return MD5.hexdigest(str);
            }
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String safeString(String orignal) {
        return TextUtils.isEmpty((CharSequence)orignal) ? "" : orignal;
    }

    public static String getAid(Context context, String appKey) {
        if (context == null) {
            return "";
        }
        return WeiboSsoManager.getInstance().getAid(context, appKey);
    }

    public static String generateUAAid(Context ctx) {
        StringBuilder buffer = new StringBuilder();
        String packageName = ctx.getPackageName();
        String sdkFlag = "weibosdk";
        if (!TextUtils.isEmpty((CharSequence)packageName) && packageName.contains("com.sina.weibo")) {
            sdkFlag = "weibo";
        }
        buffer.append(Build.MANUFACTURER).append("-").append(Build.MODEL);
        buffer.append("__");
        buffer.append(sdkFlag);
        buffer.append("__");
        try {
            String versionCode = "0041005000";
            buffer.append(versionCode.replaceAll("\\s+", "_"));
        }
        catch (Exception localE) {
            buffer.append("unknown");
        }
        buffer.append("__").append("android").append("__android").append(Build.VERSION.RELEASE);
        return buffer.toString();
    }

    public static String getWeiBoVersion(Context ctx) throws PackageManager.NameNotFoundException {
        PackageManager pm = ctx.getPackageManager();
        PackageInfo pi = null;
        pi = pm.getPackageInfo(ctx.getPackageName(), 64);
        return pi == null ? null : pi.versionName;
    }
}

