/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import com.sina.weibo.sdk.ApiUtils;
import com.sina.weibo.sdk.auth.WbAppInfo;
import com.sina.weibo.sdk.utils.MD5;

public class SecurityHelper {
    public static boolean validateAppSignatureForIntent(Context context, Intent intent) {
        PackageManager pkgMgr = context.getPackageManager();
        if (null == pkgMgr) {
            return false;
        }
        ResolveInfo resolveInfo = pkgMgr.resolveActivity(intent, 0);
        if (resolveInfo == null) {
            return false;
        }
        String packageName = resolveInfo.activityInfo.packageName;
        try {
            PackageInfo packageInfo = pkgMgr.getPackageInfo(packageName, 64);
            return SecurityHelper.containSign(packageInfo.signatures, "18da2bf10352443a00a5e046d9fca6bd");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean checkResponseAppLegal(Context context, WbAppInfo wbAppInfo, Intent intent) {
        String appPackage;
        if (wbAppInfo != null && wbAppInfo.getSupportVersion() <= 10352) {
            return true;
        }
        if (wbAppInfo == null) {
            return true;
        }
        String string = appPackage = intent != null ? intent.getStringExtra("_weibo_appPackage") : null;
        return null != appPackage && null != intent.getStringExtra("_weibo_transaction") && ApiUtils.validateWeiboSign(context, appPackage);
    }

    public static boolean containSign(Signature[] signatures, String destSign) {
        if (null == signatures || null == destSign) {
            return false;
        }
        for (Signature signature : signatures) {
            String s = MD5.hexdigest(signature.toByteArray());
            if (!destSign.equals(s)) continue;
            return true;
        }
        return false;
    }
}

