/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.statistic;

import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.sina.weibo.sdk.statistic.AdEventLog;
import com.sina.weibo.sdk.statistic.EventLog;
import com.sina.weibo.sdk.statistic.LogBuilder;
import com.sina.weibo.sdk.statistic.LogFileUtil;
import com.sina.weibo.sdk.statistic.LogReport;
import com.sina.weibo.sdk.statistic.LogType;
import com.sina.weibo.sdk.statistic.PageLog;
import com.sina.weibo.sdk.statistic.StatisticConfig;
import com.sina.weibo.sdk.statistic.WBAgentExecutor;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.Utility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

class WBAgentHandler {
    private static WBAgentHandler mInstance;
    private static CopyOnWriteArrayList<PageLog> mActivePages;
    private static Map<String, PageLog> mPages;
    private static Timer mTimer;
    private static Timer mLogTimer;
    private static int MAX_CACHE_SIZE;

    public static synchronized WBAgentHandler getInstance() {
        if (mInstance == null) {
            mInstance = new WBAgentHandler();
        }
        return mInstance;
    }

    private WBAgentHandler() {
        mActivePages = new CopyOnWriteArrayList();
        mPages = new HashMap<String, PageLog>();
        LogUtil.i("WBAgent", "init handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPageStart(String pageName) {
        if (!StatisticConfig.ACTIVITY_DURATION_OPEN) {
            PageLog pageLog = new PageLog(pageName);
            pageLog.setType(LogType.FRAGMENT);
            Map<String, PageLog> map = mPages;
            synchronized (map) {
                mPages.put(pageName, pageLog);
            }
            LogUtil.d("WBAgent", pageName + ", " + pageLog.getStartTime() / 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPageEnd(String pageName) {
        if (!StatisticConfig.ACTIVITY_DURATION_OPEN) {
            if (mPages.containsKey(pageName)) {
                PageLog pageLog = mPages.get(pageName);
                pageLog.setDuration(System.currentTimeMillis() - pageLog.getStartTime());
                Object object = mActivePages;
                synchronized (object) {
                    mActivePages.add(pageLog);
                }
                object = mPages;
                synchronized (object) {
                    mPages.remove(pageName);
                }
                LogUtil.d("WBAgent", pageName + ", " + pageLog.getStartTime() / 1000L + ", " + pageLog.getDuration() / 1000L);
            } else {
                LogUtil.e("WBAgent", "please call onPageStart before onPageEnd");
            }
            if (mActivePages.size() >= MAX_CACHE_SIZE) {
                CopyOnWriteArrayList<PageLog> copyOnWriteArrayList = mActivePages;
                synchronized (copyOnWriteArrayList) {
                    this.saveActivePages(mActivePages);
                    mActivePages.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(Context context) {
        if (LogReport.getPackageName() == null) {
            LogReport.setPackageName(context.getPackageName());
        }
        if (mTimer == null) {
            mTimer = this.timerTask(context, 500L, StatisticConfig.getUploadInterval());
        }
        long curTime = System.currentTimeMillis();
        String pageName = context.getClass().getName();
        this.checkNewSession(context, curTime);
        if (StatisticConfig.ACTIVITY_DURATION_OPEN) {
            PageLog pageLog = new PageLog(pageName, curTime);
            pageLog.setType(LogType.ACTIVITY);
            Map<String, PageLog> map = mPages;
            synchronized (map) {
                mPages.put(pageName, pageLog);
            }
        }
        LogUtil.d("WBAgent", pageName + ", " + curTime / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause(Context context) {
        long curTime = System.currentTimeMillis();
        String pageName = context.getClass().getName();
        LogUtil.i("WBAgent", "update last page endtime:" + curTime / 1000L);
        PageLog.updateSession(context, null, 0L, curTime);
        if (StatisticConfig.ACTIVITY_DURATION_OPEN) {
            if (mPages.containsKey(pageName)) {
                PageLog pageLog = mPages.get(pageName);
                pageLog.setDuration(curTime - pageLog.getStartTime());
                Object object = mActivePages;
                synchronized (object) {
                    mActivePages.add(pageLog);
                }
                object = mPages;
                synchronized (object) {
                    mPages.remove(pageName);
                }
                LogUtil.d("WBAgent", pageName + ", " + pageLog.getStartTime() / 1000L + ", " + pageLog.getDuration() / 1000L);
            } else {
                LogUtil.e("WBAgent", "please call onResume before onPause");
            }
            if (mActivePages.size() >= MAX_CACHE_SIZE) {
                CopyOnWriteArrayList<PageLog> copyOnWriteArrayList = mActivePages;
                synchronized (copyOnWriteArrayList) {
                    this.saveActivePages(mActivePages);
                    mActivePages.clear();
                }
            }
        }
        this.checkAppStatus(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(String pageName, String eventId, Map<String, String> extend) {
        EventLog eventLog = new EventLog(pageName, eventId, extend);
        eventLog.setType(LogType.EVENT);
        CopyOnWriteArrayList<PageLog> copyOnWriteArrayList = mActivePages;
        synchronized (copyOnWriteArrayList) {
            mActivePages.add(eventLog);
        }
        if (extend == null) {
            LogUtil.d("WBAgent", "event--- page:" + pageName + " ,event name:" + eventId);
        } else {
            LogUtil.d("WBAgent", "event--- page:" + pageName + " ,event name:" + eventId + " ,extend:" + extend.toString());
        }
        if (mActivePages.size() >= MAX_CACHE_SIZE) {
            copyOnWriteArrayList = mActivePages;
            synchronized (copyOnWriteArrayList) {
                this.saveActivePages(mActivePages);
                mActivePages.clear();
            }
        }
    }

    public void uploadAppLogs(final Context context) {
        long duration = System.currentTimeMillis() - LogReport.getTime(context);
        if (LogReport.getTime(context) > 0L && duration < 30000L) {
            this.timerTask(context, 30000L - duration, 0L);
        } else {
            WBAgentExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    LogReport.uploadAppLogs(context, WBAgentHandler.this.getLogsInMemory());
                }
            });
        }
    }

    public void onStop(Context context) {
        this.checkAppStatus(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAppStatus(Context context) {
        if (this.isBackground(context)) {
            CopyOnWriteArrayList<PageLog> copyOnWriteArrayList = mActivePages;
            synchronized (copyOnWriteArrayList) {
                this.saveActivePages(mActivePages);
                mActivePages.clear();
            }
        }
    }

    private boolean isBackground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(context.getPackageName())) continue;
            if (appProcess.importance == 400) {
                LogUtil.i("WBAgent", "\u540e\u53f0:" + appProcess.processName);
                return true;
            }
            LogUtil.i("WBAgent", "\u524d\u53f0:" + appProcess.processName);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKillProcess() {
        LogUtil.i("WBAgent", "save applogs and close timer and shutdown thread executor");
        CopyOnWriteArrayList<PageLog> copyOnWriteArrayList = mActivePages;
        synchronized (copyOnWriteArrayList) {
            this.saveActivePages(mActivePages);
        }
        mInstance = null;
        this.closeTimer();
        WBAgentExecutor.shutDownExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNewSession(Context context, long curTime) {
        if (PageLog.isNewSession(context, curTime)) {
            PageLog old_session = new PageLog(context);
            old_session.setType(LogType.SESSION_END);
            PageLog new_session = new PageLog(context, curTime);
            new_session.setType(LogType.SESSION_START);
            CopyOnWriteArrayList<PageLog> copyOnWriteArrayList = mActivePages;
            synchronized (copyOnWriteArrayList) {
                if (old_session.getEndTime() > 0L) {
                    mActivePages.add(old_session);
                } else {
                    LogUtil.d("WBAgent", "is a new install");
                }
                mActivePages.add(new_session);
            }
            LogUtil.d("WBAgent", "last session--- starttime:" + old_session.getStartTime() + " ,endtime:" + old_session.getEndTime());
            LogUtil.d("WBAgent", "is a new session--- starttime:" + new_session.getStartTime());
        } else {
            LogUtil.i("WBAgent", "is not a new session");
        }
    }

    private synchronized void saveActivePages(CopyOnWriteArrayList<PageLog> pages) {
        final String content = LogBuilder.getPageLogs(pages);
        WBAgentExecutor.execute(new Runnable(){

            @Override
            public void run() {
                LogFileUtil.writeToFile(LogFileUtil.getAppLogPath("app_logs"), content, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getLogsInMemory() {
        String memorylogs = "";
        if (mActivePages.size() > 0) {
            CopyOnWriteArrayList<PageLog> copyOnWriteArrayList = mActivePages;
            synchronized (copyOnWriteArrayList) {
                memorylogs = LogBuilder.getPageLogs(mActivePages);
                mActivePages.clear();
            }
        }
        return memorylogs;
    }

    private Timer timerTask(final Context context, long delay, long peirod) {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                LogReport.uploadAppLogs(context, WBAgentHandler.this.getLogsInMemory());
            }
        };
        if (peirod == 0L) {
            timer.schedule(task, delay);
        } else {
            timer.schedule(task, delay, peirod);
        }
        return timer;
    }

    private void closeTimer() {
        if (mTimer != null) {
            mTimer.cancel();
            mTimer = null;
        }
    }

    public void registerApptoAd(final Context context, final String appKey, Map<String, String> extend) {
        try {
            final AdEventLog eventLog = new AdEventLog();
            eventLog.setType(LogType.APP_AD_START);
            if (WBAgentHandler.isFirstStartBoolean(context)) {
                eventLog.setmEvent_id("1");
            }
            eventLog.setmImei(MD5.hexdigest(WBAgentHandler.getImei(context)));
            eventLog.setmStart_time(System.currentTimeMillis());
            eventLog.setmExtend(extend);
            String aid = Utility.getAid(context, appKey);
            if (TextUtils.isEmpty((CharSequence)aid)) {
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        String aid = Utility.getAid(context, appKey);
                        eventLog.setmAid(aid);
                        WBAgentHandler.this.uploadAdlog(context, eventLog);
                    }
                };
                mLogTimer = new Timer();
                mLogTimer.schedule(task, 5000L);
            } else {
                eventLog.setmAid(aid);
                this.uploadAdlog(context, eventLog);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getImei(Context ctx) {
        try {
            TelephonyManager telePhonyMgr = (TelephonyManager)ctx.getSystemService("phone");
            return telePhonyMgr.getDeviceId();
        }
        catch (Exception var2) {
            return "";
        }
    }

    public void uploadAdlog(final Context context, AdEventLog eventLog) {
        mActivePages.add(eventLog);
        WBAgentExecutor.execute(new Runnable(){

            @Override
            public void run() {
                LogReport.uploadAppLogs(context, WBAgentHandler.this.getLogsInMemory());
            }
        });
    }

    public static boolean isFirstStartBoolean(Context context) {
        SharedPreferences pref = context.getSharedPreferences("third_app_is_first_tag", 0);
        boolean firstFlag = pref.getBoolean("third_app_is_first_key", true);
        if (firstFlag) {
            SharedPreferences.Editor editor = pref.edit();
            editor.putBoolean("third_app_is_first_key", false);
            editor.commit();
        }
        return firstFlag;
    }

    static {
        MAX_CACHE_SIZE = 5;
    }
}

