/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.statistic;

import android.content.Context;
import android.content.SharedPreferences;
import com.sina.weibo.sdk.statistic.LogType;
import com.sina.weibo.sdk.statistic.StatisticConfig;

class PageLog {
    protected LogType mType;
    protected String mPage_id;
    protected long mStart_time;
    private long mEnd_time;
    private long mDuration;
    private static String FILE_SESSION = "session";
    private static long MIN_ENDTIME = 1000L;

    public PageLog(Context context) {
        this.mStart_time = PageLog.getSessionTime(context, "starttime");
        this.mEnd_time = PageLog.getSessionTime(context, "endtime");
        this.mDuration = this.mEnd_time - this.mStart_time;
    }

    public PageLog(String pageName) {
        this.mPage_id = pageName;
        this.mStart_time = System.currentTimeMillis();
    }

    public PageLog(Context context, long time) {
        this.mStart_time = time;
        this.mEnd_time = MIN_ENDTIME;
        PageLog.updateSession(context, null, this.mStart_time, this.mEnd_time);
    }

    public PageLog() {
    }

    public PageLog(String pageName, long time) {
        this.mPage_id = pageName;
        this.mStart_time = time;
    }

    public LogType getType() {
        return this.mType;
    }

    public void setType(LogType type) {
        this.mType = type;
    }

    public String getPage_id() {
        return this.mPage_id;
    }

    public long getStartTime() {
        return this.mStart_time;
    }

    public long getEndTime() {
        return this.mEnd_time;
    }

    public void setDuration(long mDuration) {
        this.mDuration = mDuration;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setmStart_time(long mStart_time) {
        this.mStart_time = mStart_time;
    }

    public static boolean isNewSession(Context context, long curTime) {
        long last_endtime = PageLog.getSessionTime(context, "endtime");
        if (last_endtime > MIN_ENDTIME) {
            return curTime - last_endtime > StatisticConfig.kContinueSessionMillis;
        }
        return last_endtime != MIN_ENDTIME;
    }

    private static long getSessionTime(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(FILE_SESSION, 0);
        return sp.getLong(key, 0L);
    }

    public static void updateSession(Context context, String session_id, Long starttime, Long endtime) {
        SharedPreferences sp = context.getSharedPreferences(FILE_SESSION, 0);
        SharedPreferences.Editor editor = sp.edit();
        if (starttime != 0L) {
            editor.putLong("starttime", starttime.longValue());
        }
        editor.putLong("endtime", endtime.longValue());
        editor.commit();
    }
}

