/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.statistic;

import android.os.Environment;
import android.text.TextUtils;
import com.sina.weibo.sdk.statistic.LogReport;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

class LogFileUtil {
    private static final String SDCARD_WEIBO_ANALYTICS_DIR = "/sina/weibo/.applogs/";
    public static final String ANALYTICS_FILE_NAME = "app_logs";
    private static final String ANALYTICS_FILE_SUFFIX = ".txt";

    LogFileUtil() {
    }

    public static String getAppLogs(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        return LogFileUtil.readStringFromFile(filePath);
    }

    public static String getAppLogPath(String fileName) {
        String filePath = "";
        String parent = "";
        if (LogReport.getPackageName() != null) {
            parent = MD5.hexdigest(LogReport.getPackageName()) + "/";
        }
        filePath = LogFileUtil.getSDPath() + SDCARD_WEIBO_ANALYTICS_DIR + parent + fileName + ANALYTICS_FILE_SUFFIX;
        return filePath;
    }

    private static String getSDPath() {
        File sdDir = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            sdDir = Environment.getExternalStorageDirectory();
        }
        if (sdDir != null) {
            return sdDir.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStringFromFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        File file = new File(path);
        if (!file.isFile() || !file.exists()) {
            return "";
        }
        BufferedReader reader = null;
        StringBuilder content = new StringBuilder((int)file.length());
        try {
            reader = new BufferedReader(new FileReader(file));
            String temp = null;
            while ((temp = reader.readLine()) != null) {
                content.append(temp);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void writeToFile(String filePath, String content, boolean isAppend) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return;
        }
        LogUtil.i("WBAgent", "filePath:" + filePath);
        if (content == null || content.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(content);
        if (sb.charAt(0) == '[') {
            sb.replace(0, 1, "");
        }
        if (sb.charAt(sb.length() - 1) != ',') {
            sb.replace(sb.length() - 1, sb.length(), ",");
        }
        File file = new File(filePath);
        OutputStreamWriter fileWriter = null;
        try {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            } else if (file.lastModified() > 0L && System.currentTimeMillis() - file.lastModified() > 86400000L) {
                isAppend = false;
            }
            fileWriter = new FileWriter(file, isAppend);
            fileWriter.write(sb.toString());
            fileWriter.flush();
        }
        catch (IOException e) {
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean delete(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            file.delete();
            return true;
        }
        return false;
    }
}

