/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.sso;

import android.content.Context;
import android.text.TextUtils;
import com.sina.weibo.sdk.utils.LogUtil;
import com.weibo.ssosdk.MfpBuilder;
import com.weibo.ssosdk.WeiboSsoSdk;
import com.weibo.ssosdk.WeiboSsoSdkConfig;

public final class WeiboSsoManager {
    private static final String TAG = "WeiboSsoManager";
    private String aid;

    private WeiboSsoManager() {
    }

    public static synchronized WeiboSsoManager getInstance() {
        return Instance.instance;
    }

    public void init(Context context, String appkey) {
        LogUtil.d(TAG, "init config");
        WeiboSsoSdkConfig cfg = new WeiboSsoSdkConfig();
        cfg.setContext(context);
        cfg.setAppKey(appkey);
        cfg.setFrom("1478195010");
        cfg.setWm("1000_0001");
        WeiboSsoSdk.initConfig((WeiboSsoSdkConfig)cfg);
        this.initAid();
    }

    private void initAid() {
        try {
            this.aid = WeiboSsoSdk.getInstance().getAid();
            if (TextUtils.isEmpty((CharSequence)this.aid)) {
                this.aid = WeiboSsoSdk.getInstance().visitorLogin().getAid();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.e(TAG, e.getMessage());
        }
    }

    public String getAid(Context context, String appkey) {
        LogUtil.d(TAG, "getAid()");
        if (TextUtils.isEmpty((CharSequence)this.aid)) {
            this.init(context, appkey);
        }
        return this.aid;
    }

    public String getMfp(Context context) {
        return MfpBuilder.getMfp((Context)context);
    }

    private static class Instance {
        private static final WeiboSsoManager instance = new WeiboSsoManager();

        private Instance() {
        }
    }
}

