/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.share;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.sina.weibo.sdk.WbSdk;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.api.StoryObject;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.auth.WbAppInfo;
import com.sina.weibo.sdk.share.BaseActivity;
import com.sina.weibo.sdk.share.CopyResourceTask;
import com.sina.weibo.sdk.share.TransResourceCallback;
import com.sina.weibo.sdk.share.TransResourceResult;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.Utility;
import com.sina.weibo.sdk.web.view.WbSdkProgressBar;

public class WbShareTransActivity
extends BaseActivity {
    boolean flag = false;
    private CopyResourceTask copyResourceTask;
    private FrameLayout rootLayout;
    private Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            WbShareTransActivity.this.sendCallback(1);
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LogUtil.d("Share", "startShareTransActivity");
        this.initView();
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        int startFlag = intent.getIntExtra("startFlag", -1);
        if (startFlag != 0) {
            this.finish();
            return;
        }
        this.checkSource(intent);
    }

    private void checkSource(Intent intent) {
        try {
            Bundle bundle = intent.getExtras();
            if (bundle == null) {
                this.finish();
                return;
            }
            WeiboMultiMessage multiMessage = new WeiboMultiMessage();
            multiMessage.toObject(bundle);
            this.transPicAndVideoResource(multiMessage);
        }
        catch (Exception e) {
            this.finish();
        }
    }

    private void initView() {
        WbSdkProgressBar progressBar;
        int progressColor = this.getIntent().getIntExtra("progressColor", -1);
        int progressId = this.getIntent().getIntExtra("progressId", -1);
        this.rootLayout = new FrameLayout((Context)this);
        if (progressId != -1) {
            LayoutInflater inflater = (LayoutInflater)this.getSystemService("layout_inflater");
            try {
                progressBar = inflater.inflate(progressId, null);
            }
            catch (Exception e) {
                progressBar = new WbSdkProgressBar((Context)this);
            }
        } else {
            progressBar = new WbSdkProgressBar((Context)this);
            if (progressColor != -1) {
                progressBar.setProgressColor(progressColor);
            }
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        this.rootLayout.addView((View)progressBar, (ViewGroup.LayoutParams)params);
        this.rootLayout.setBackgroundColor(0x33000000);
    }

    private void gotoWeiboComposer(WeiboMultiMessage weiboMultiMessage) {
        LogUtil.d("Share", "gotoWeiboComposer");
        Intent intent = this.getIntent();
        this.flag = true;
        try {
            intent.putExtra("startFlag", -1);
            Intent shareIntent = new Intent("com.sina.weibo.sdk.action.ACTION_WEIBO_ACTIVITY");
            Bundle shareBundle = intent.getExtras();
            weiboMultiMessage.toBundle(shareBundle);
            shareIntent.putExtras(shareBundle);
            String appPackage = this.getPackageName();
            shareIntent.putExtra("_weibo_sdkVersion", "0041005000");
            shareIntent.putExtra("_weibo_appPackage", appPackage);
            shareIntent.putExtra("_weibo_appKey", WbSdk.getAuthInfo().getAppKey());
            shareIntent.putExtra("_weibo_flag", 538116905);
            shareIntent.putExtra("_weibo_sign", MD5.hexdigest(Utility.getSign((Context)this, appPackage)));
            String gotoActivity = intent.getStringExtra("gotoActivity");
            if (!TextUtils.isEmpty((CharSequence)gotoActivity) && "com.sina.weibo.sdk.web.WeiboSdkWebActivity".equals(gotoActivity)) {
                shareIntent.setClassName((Context)this, "com.sina.weibo.sdk.web.WeiboSdkWebActivity");
                this.startActivityForResult(shareIntent, 765);
            } else if (WbSdk.isWbInstall((Context)this)) {
                WbAppInfo wbAppInfo = WeiboAppManager.getInstance((Context)this).getWbAppInfo();
                if (wbAppInfo != null) {
                    shareIntent.setPackage(wbAppInfo.getPackageName());
                    this.startActivityForResult(shareIntent, 765);
                } else {
                    this.startActivityForResult(shareIntent, 765);
                }
            } else {
                this.sendCallback(2);
            }
        }
        catch (Exception e) {
            this.sendCallback(2);
        }
    }

    private void transPicAndVideoResource(WeiboMultiMessage multiMessage) {
        this.setContentView((View)this.rootLayout);
        if (multiMessage.multiImageObject != null || multiMessage.videoSourceObject != null) {
            if (this.copyResourceTask != null) {
                this.copyResourceTask.cancel(true);
            }
            this.copyResourceTask = new CopyResourceTask((Context)this, new TransResourceCallback(){

                @Override
                public void onTransFinish(TransResourceResult result) {
                    WbShareTransActivity.this.rootLayout.setVisibility(4);
                    if (result != null && result.transDone) {
                        WbShareTransActivity.this.gotoWeiboComposer(result.message);
                    } else {
                        WbShareTransActivity.this.sendCallback(2);
                    }
                }

                @Override
                public void onTransFinish(StoryObject object) {
                }
            });
            Object[] messages = new WeiboMultiMessage[]{multiMessage};
            this.copyResourceTask.execute(messages);
        } else {
            this.gotoWeiboComposer(multiMessage);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.handler != null) {
            this.handler.sendEmptyMessageDelayed(0, 100L);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        LogUtil.i("Share", "startTransActivity.onNewIntent()");
        if (this.handler != null) {
            this.handler.removeMessages(0);
            this.handler = null;
        }
        this.setResult(-1, intent);
        this.finish();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.remove("startFlag");
    }

    private void sendCallback(int resultCode) {
        if (this.rootLayout != null) {
            this.rootLayout.setVisibility(8);
        }
        try {
            Intent resultIntent = new Intent();
            Bundle bundle = new Bundle();
            bundle.putInt("_weibo_resp_errcode", resultCode);
            resultIntent.putExtras(bundle);
            this.setResult(-1, resultIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.handler != null) {
            this.handler.removeMessages(0);
            this.handler = null;
        }
        this.finish();
    }
}

