/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.share;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.sina.weibo.sdk.WbSdk;
import com.sina.weibo.sdk.api.StoryMessage;
import com.sina.weibo.sdk.api.StoryObject;
import com.sina.weibo.sdk.share.BaseActivity;
import com.sina.weibo.sdk.share.SaveFileTask;
import com.sina.weibo.sdk.share.TransResourceCallback;
import com.sina.weibo.sdk.share.TransResourceResult;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.web.view.WbSdkProgressBar;

public class WbShareToStoryActivity
extends BaseActivity {
    private SaveFileTask saveFileTask;
    private String callbackActivity;
    private FrameLayout rootLayout;
    private View progressBar;
    private int progressColor = -1;
    private int progressId = -1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        try {
            this.callbackActivity = savedInstanceState != null ? savedInstanceState.getString("startActivity") : intent.getStringExtra("startActivity");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int startFlag = intent.getIntExtra("startFlag", -1);
        if (startFlag != 0) {
            this.finish();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.callbackActivity)) {
            this.finish();
            return;
        }
        StoryMessage storyMessage = null;
        try {
            storyMessage = (StoryMessage)this.getIntent().getParcelableExtra("_weibo_message_stroy");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (storyMessage == null) {
            this.setCallbackActivity(2);
            return;
        }
        if (!this.checkInfo(storyMessage)) {
            this.setCallbackActivity(2);
            return;
        }
        this.initView();
        this.gotoSave(storyMessage);
    }

    private void initView() {
        try {
            this.progressColor = this.getIntent().getIntExtra("progressColor", -1);
            this.progressId = this.getIntent().getIntExtra("progressId", -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rootLayout = new FrameLayout((Context)this);
        if (this.progressId != -1) {
            LayoutInflater inflater = (LayoutInflater)this.getSystemService("layout_inflater");
            try {
                this.progressBar = inflater.inflate(this.progressId, null);
            }
            catch (Exception e) {
                this.progressBar = new WbSdkProgressBar((Context)this);
            }
        } else {
            this.progressBar = new WbSdkProgressBar((Context)this);
            if (this.progressColor != -1) {
                ((WbSdkProgressBar)this.progressBar).setProgressColor(this.progressColor);
            }
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        this.rootLayout.addView(this.progressBar, (ViewGroup.LayoutParams)params);
        this.rootLayout.setBackgroundColor(0x33000000);
        this.setContentView((View)this.rootLayout);
    }

    private boolean checkInfo(StoryMessage storyMessage) {
        return storyMessage.checkSource() && WbSdk.supportMultiImage((Context)this);
    }

    private void gotoSave(StoryMessage storyMessage) {
        if (this.saveFileTask != null) {
            this.saveFileTask.cancel(true);
        }
        this.saveFileTask = new SaveFileTask((Context)this, new TransResourceCallback(){

            @Override
            public void onTransFinish(TransResourceResult result) {
            }

            @Override
            public void onTransFinish(StoryObject object) {
                if (object != null) {
                    try {
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"sinaweibo://story/publish?forceedit=1&finish=true"));
                        intent.setPackage(intent.getStringExtra("startPackage"));
                        intent.putExtra("storyData", (Parcelable)object);
                        WbShareToStoryActivity.this.startActivity(intent);
                    }
                    catch (Exception e) {
                        WbShareToStoryActivity.this.setCallbackActivity(2);
                    }
                } else {
                    WbShareToStoryActivity.this.setCallbackActivity(2);
                }
            }
        });
        this.saveFileTask.execute(new StoryMessage[]{storyMessage});
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        int responseFlag = 0;
        try {
            responseFlag = intent.getIntExtra("backType", 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (responseFlag == 0) {
            this.setCallbackActivity(1);
        } else {
            this.setCallbackActivity(0);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("startActivity", this.callbackActivity);
    }

    private void setCallbackActivity(int resultCode) {
        if (this.rootLayout != null) {
            this.rootLayout.setVisibility(8);
        }
        try {
            Intent intent = new Intent();
            intent.putExtra("_weibo_resp_errcode", resultCode);
            this.setResult(-1, intent);
        }
        catch (Exception e) {
            LogUtil.v("weibo sdk", e.toString());
        }
        this.finish();
    }
}

