/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.share;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.sina.weibo.sdk.WbSdk;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.api.StoryMessage;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.auth.AccessTokenKeeper;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.auth.WbAppInfo;
import com.sina.weibo.sdk.share.WbShareCallback;
import com.sina.weibo.sdk.share.WbShareToStoryActivity;
import com.sina.weibo.sdk.share.WbShareTransActivity;
import com.sina.weibo.sdk.utils.FileUtils;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.Utility;
import com.sina.weibo.sdk.web.WebRequestType;
import com.sina.weibo.sdk.web.param.ShareWebViewRequestParam;

public class WbShareHandler {
    public static final int WB_SHARE_REQUEST = 1;
    private boolean hasRegister = false;
    private Activity context;
    private int progressColor = -1;
    private int progressId = -1;

    public WbShareHandler(Activity context) {
        this.context = context;
    }

    public boolean registerApp() {
        this.sendBroadcast((Context)this.context, "com.sina.weibo.sdk.Intent.ACTION_WEIBO_REGISTER", WbSdk.getAuthInfo().getAppKey(), null, null);
        this.hasRegister = true;
        return true;
    }

    private void sendBroadcast(Context context, String action, String key, String packageName, Bundle data) {
        Intent intent = new Intent(action);
        String appPackage = context.getPackageName();
        intent.putExtra("_weibo_sdkVersion", "0041005000");
        intent.putExtra("_weibo_appPackage", appPackage);
        intent.putExtra("_weibo_appKey", key);
        intent.putExtra("_weibo_flag", 538116905);
        intent.putExtra("_weibo_sign", MD5.hexdigest(Utility.getSign(context, appPackage)));
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            intent.setPackage(packageName);
        }
        if (data != null) {
            intent.putExtras(data);
        }
        context.sendBroadcast(intent, "com.sina.weibo.permission.WEIBO_SDK_PERMISSION");
    }

    public void shareMessage(WeiboMultiMessage message, boolean clientOnly) {
        if (!this.hasRegister) {
            throw new RuntimeException("please call WbShareHandler.registerApp(),before use share function");
        }
        if (!WbSdk.isWbInstall((Context)this.context) && clientOnly) {
            return;
        }
        if (clientOnly) {
            this.startClientShare(message);
            return;
        }
        WbAppInfo wbAppInfo = WeiboAppManager.getInstance((Context)this.context).getWbAppInfo();
        if (WbSdk.isWbInstall((Context)this.context) && wbAppInfo != null && wbAppInfo.getSupportVersion() > 10000) {
            this.startClientShare(message);
        } else {
            this.startWebShare(message);
        }
    }

    public void shareToStory(StoryMessage storyMessage) {
        Uri imageUri = storyMessage.getImageUri();
        Uri videoUri = storyMessage.getVideoUri();
        if (!(imageUri != null && FileUtils.isImageFile((Context)this.context, imageUri) || videoUri != null && FileUtils.isVideoFile((Context)this.context, videoUri))) {
            throw new IllegalStateException("File only can be Image or Video. ");
        }
        Intent intent = new Intent();
        intent.putExtra("_weibo_message_stroy", (Parcelable)storyMessage);
        intent.putExtra("startActivity", this.context.getClass().getName());
        intent.putExtra("startPackage", WeiboAppManager.getInstance((Context)this.context).getWbAppInfo().getPackageName());
        intent.putExtra("progressColor", this.progressColor);
        intent.putExtra("progressId", this.progressId);
        intent.putExtra("startFlag", 0);
        intent.setClass((Context)this.context, WbShareToStoryActivity.class);
        this.context.startActivityForResult(intent, 1);
    }

    private void startClientShare(WeiboMultiMessage message) {
        Bundle data = new Bundle();
        data.putInt("_weibo_command_type", 1);
        data.putString("_weibo_transaction", String.valueOf(System.currentTimeMillis()));
        data.putLong("callbackId", 0L);
        data.putAll(message.toBundle(data));
        Intent intent = new Intent();
        intent.setClass((Context)this.context, WbShareTransActivity.class);
        intent.putExtra("startFlag", 0);
        intent.putExtra("startActivity", this.context.getClass().getName());
        intent.putExtra("progressColor", this.progressColor);
        intent.putExtra("progressId", this.progressId);
        intent.putExtras(data);
        try {
            this.context.startActivityForResult(intent, 1);
        }
        catch (Exception e) {
            LogUtil.v("weibo sdk error ", e.toString());
        }
    }

    private void startWebShare(WeiboMultiMessage message) {
        LogUtil.i("Share", "startWebShare");
        Intent webIntent = new Intent((Context)this.context, WbShareTransActivity.class);
        String appPackage = this.context.getPackageName();
        ShareWebViewRequestParam webParam = new ShareWebViewRequestParam(WbSdk.getAuthInfo(), WebRequestType.SHARE, "", 1, "\u5fae\u535a\u5206\u4eab", null, (Context)this.context);
        webParam.setContext((Context)this.context);
        webParam.setHashKey("");
        webParam.setPackageName(appPackage);
        Oauth2AccessToken token = AccessTokenKeeper.readAccessToken((Context)this.context);
        if (token != null && !TextUtils.isEmpty((CharSequence)token.getToken())) {
            webParam.setToken(token.getToken());
        }
        webParam.setMultiMessage(message);
        Bundle bundle = new Bundle();
        webParam.fillBundle(bundle);
        webIntent.putExtras(bundle);
        webIntent.putExtra("startFlag", 0);
        webIntent.putExtra("startActivity", this.context.getClass().getName());
        webIntent.putExtra("startAction", "com.sina.weibo.sdk.action.ACTION_WEIBO_ACTIVITY");
        webIntent.putExtra("gotoActivity", "com.sina.weibo.sdk.web.WeiboSdkWebActivity");
        this.context.startActivityForResult(webIntent, 1);
    }

    @Deprecated
    public boolean isWbAppInstalled() {
        return WbSdk.isWbInstall((Context)this.context);
    }

    public void doResultIntent(Intent intent, WbShareCallback callback) {
        if (callback == null) {
            return;
        }
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return;
        }
        int resultCode = bundle.getInt("_weibo_resp_errcode", -1);
        switch (resultCode) {
            case 0: {
                callback.onWbShareSuccess();
                break;
            }
            case 1: {
                callback.onWbShareCancel();
                break;
            }
            case 2: {
                callback.onWbShareFail();
            }
        }
    }

    public boolean supportMulti() {
        return false;
    }

    public void setProgressColor(int color) {
        this.progressColor = color;
    }

    public void setProgressId(int id) {
        this.progressId = id;
    }
}

