/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.share;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.auth.WbAppInfo;
import com.sina.weibo.sdk.utils.LogUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;

public final class ShareUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String copyFileToWeiboTem(Context context, Uri uri, int type) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int readBytes;
            WbAppInfo wbAppInfo = WeiboAppManager.queryWbInfoInternal(context);
            String packageName = wbAppInfo.getPackageName();
            if (TextUtils.isEmpty((CharSequence)packageName)) {
                packageName = "com.sina.weibo";
            }
            String tempPath = "/Android/data/" + packageName + "/files/.composerTem/";
            File file = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + tempPath);
            file.mkdirs();
            Calendar calendar = Calendar.getInstance();
            String fileName = null;
            try (Cursor cursor = null;){
                if (uri.getScheme().equals("file")) {
                    fileName = calendar.getTimeInMillis() + uri.getLastPathSegment();
                } else {
                    cursor = context.getContentResolver().query(uri, new String[]{"_display_name"}, null, null, null);
                    if (cursor != null && cursor.moveToFirst()) {
                        fileName = cursor.getString(cursor.getColumnIndex("_display_name"));
                    }
                }
            }
            if (TextUtils.isEmpty(fileName)) {
                fileName = Calendar.getInstance().getTimeInMillis() + (type == 0 ? "_sdk_temp.mp4" : "_sdk_temp.jpg");
            }
            ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            inputStream = new BufferedInputStream(new FileInputStream(fileDescriptor));
            File temFile = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + tempPath + fileName);
            if (temFile.exists()) {
                temFile.delete();
            }
            outputStream = new FileOutputStream(temFile);
            byte[] buffer = new byte[1444];
            while ((readBytes = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, readBytes);
            }
            String string = temFile.getPath();
            return string;
        }
        catch (Exception e) {
            LogUtil.e("weibo sdk copy", e.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

