/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.share;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.sina.weibo.sdk.WbSdk;
import com.sina.weibo.sdk.api.StoryMessage;
import com.sina.weibo.sdk.api.StoryObject;
import com.sina.weibo.sdk.share.ShareUtils;
import com.sina.weibo.sdk.share.TransResourceCallback;
import com.sina.weibo.sdk.utils.FileUtils;
import java.lang.ref.WeakReference;

public class SaveFileTask
extends AsyncTask<StoryMessage, Object, StoryObject> {
    private WeakReference<Context> mReference;
    private TransResourceCallback mCallback;

    public SaveFileTask(Context context, TransResourceCallback callback) {
        this.mReference = new WeakReference<Context>(context);
        this.mCallback = callback;
    }

    protected StoryObject doInBackground(StoryMessage ... params) {
        StoryMessage storyMessage = params[0];
        if (storyMessage == null) {
            return null;
        }
        Uri imageUri = storyMessage.getImageUri();
        Uri videoUri = storyMessage.getVideoUri();
        Context context = (Context)this.mReference.get();
        if (context == null) {
            return null;
        }
        if (imageUri != null && FileUtils.isImageFile(context, imageUri)) {
            return this.copyFileToWeiboTem(context, imageUri, 1);
        }
        if (videoUri != null && FileUtils.isVideoFile(context, videoUri)) {
            return this.copyFileToWeiboTem(context, videoUri, 0);
        }
        return null;
    }

    private StoryObject copyFileToWeiboTem(Context context, Uri uri, int type) {
        String path = ShareUtils.copyFileToWeiboTem(context, uri, type);
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        StoryObject storyObject = new StoryObject();
        storyObject.sourcePath = path;
        storyObject.sourceType = type;
        storyObject.appId = WbSdk.getAuthInfo().getAppKey();
        storyObject.appPackage = context.getPackageName();
        return storyObject;
    }

    protected void onPostExecute(StoryObject o) {
        super.onPostExecute((Object)o);
        if (this.mCallback != null) {
            this.mCallback.onTransFinish(o);
        }
    }
}

