/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.share;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.sina.weibo.sdk.WbSdk;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.auth.WbAppInfo;
import com.sina.weibo.sdk.share.ShareUtils;
import com.sina.weibo.sdk.share.TransResourceCallback;
import com.sina.weibo.sdk.share.TransResourceResult;
import com.sina.weibo.sdk.utils.FileUtils;
import com.sina.weibo.sdk.utils.ImageUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class CopyResourceTask
extends AsyncTask<WeiboMultiMessage, Object, TransResourceResult> {
    private WeakReference<Context> mReference;
    private TransResourceCallback mCallback;

    public CopyResourceTask(Context context, TransResourceCallback callback) {
        this.mReference = new WeakReference<Context>(context);
        this.mCallback = callback;
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected TransResourceResult doInBackground(WeiboMultiMessage ... params) {
        Context context = (Context)this.mReference.get();
        if (context == null) {
            return null;
        }
        WeiboMultiMessage multiMessage = params[0];
        TransResourceResult transResourceResult = new TransResourceResult();
        try {
            if (WbSdk.isWbInstall(context)) {
                Uri videoUri;
                WbAppInfo wbAppInfo = WeiboAppManager.queryWbInfoInternal(context);
                if (wbAppInfo != null && wbAppInfo.getSupportVersion() >= 10772) {
                    if (multiMessage.imageObject != null && multiMessage.multiImageObject != null) {
                        multiMessage.imageObject = null;
                    }
                    if (multiMessage.videoSourceObject != null && (multiMessage.multiImageObject != null || multiMessage.imageObject != null)) {
                        multiMessage.multiImageObject = null;
                        multiMessage.imageObject = null;
                    }
                } else {
                    multiMessage.multiImageObject = null;
                    multiMessage.videoSourceObject = null;
                }
                if (multiMessage.multiImageObject != null) {
                    ArrayList<Uri> copyPathList = new ArrayList<Uri>();
                    for (Uri uri : multiMessage.multiImageObject.getImageList()) {
                        String copyFile;
                        if (uri == null || !FileUtils.isImageFile(context, uri) || TextUtils.isEmpty((CharSequence)(copyFile = ShareUtils.copyFileToWeiboTem(context, uri, 1)))) continue;
                        copyPathList.add(Uri.fromFile((File)new File(copyFile)));
                    }
                    multiMessage.multiImageObject.setImageList(copyPathList);
                }
                if (multiMessage.videoSourceObject != null && (videoUri = multiMessage.videoSourceObject.videoPath) != null && FileUtils.isVideoFile(context, videoUri)) {
                    String videoPath = ShareUtils.copyFileToWeiboTem(context, videoUri, 0);
                    multiMessage.videoSourceObject.videoPath = Uri.fromFile((File)new File(videoPath));
                    multiMessage.videoSourceObject.during = ImageUtils.getVideoDuring(videoPath);
                }
            }
            transResourceResult.message = multiMessage;
            transResourceResult.transDone = true;
        }
        catch (Exception e) {
            transResourceResult.transDone = false;
        }
        return transResourceResult;
    }

    protected void onPostExecute(TransResourceResult o) {
        super.onPostExecute((Object)o);
        if (this.mCallback != null) {
            this.mCallback.onTransFinish(o);
        }
    }
}

