/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.network.intercept;

import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.network.IRequestIntercept;
import com.sina.weibo.sdk.network.IRequestParam;
import com.sina.weibo.sdk.network.base.WbUserInfo;
import com.sina.weibo.sdk.network.base.WbUserInfoHelper;
import com.sina.weibo.sdk.network.exception.InterceptException;
import com.sina.weibo.wcfc.sobusiness.UtilitySo;

public class GuestParamInterception
implements IRequestIntercept {
    @Override
    public boolean needIntercept(IRequestParam param, Bundle paramBundle) {
        String path = param.getUrl();
        return TextUtils.isEmpty((CharSequence)path) || !path.startsWith("https://api.weibo.cn/2/sdk/login") && !path.startsWith("http://api.weibo.cn/2/sdk/login");
    }

    @Override
    public boolean doIntercept(IRequestParam param, Bundle paramBundle) throws InterceptException {
        WbUserInfo userInfo = WbUserInfoHelper.getInstance().getUserInfo(param.getContext());
        if (userInfo != null) {
            paramBundle.putString("gsid", userInfo.getGsid());
            paramBundle.putString("uid", userInfo.getUid());
            String s = UtilitySo.getInstance().calculateS(param.getContext(), userInfo.getUid());
            paramBundle.putString("s", s);
        }
        return false;
    }
}

