/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.network.intercept;

import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.net.HttpManager;
import com.sina.weibo.sdk.network.IRequestIntercept;
import com.sina.weibo.sdk.network.IRequestParam;
import com.sina.weibo.sdk.network.exception.InterceptException;
import com.sina.weibo.sdk.sso.WeiboSsoManager;
import com.sina.weibo.sdk.utils.LogUtil;

public class CommonParamInterception
implements IRequestIntercept {
    public static String aidInfo;
    private static String appKey;

    @Override
    public boolean needIntercept(IRequestParam param, Bundle paramBundle) {
        return true;
    }

    public static void setAppKey(String key) {
        appKey = key;
    }

    @Override
    public boolean doIntercept(IRequestParam param, Bundle paramBundle) throws InterceptException {
        if (TextUtils.isEmpty((CharSequence)aidInfo)) {
            aidInfo = WeiboSsoManager.getInstance().getAid(param.getContext(), appKey);
        }
        if (TextUtils.isEmpty((CharSequence)aidInfo)) {
            throw new InterceptException("aid get error");
        }
        if (!TextUtils.isEmpty((CharSequence)aidInfo)) {
            paramBundle.putString("aid", aidInfo);
        }
        Bundle bundle = null;
        bundle = param.getMethod() == IRequestParam.RequestType.GET ? param.getGetBundle() : param.getPostBundle();
        String token = "";
        Object accessToken = bundle.get("access_token");
        Object refreshToken = bundle.get("refresh_token");
        Object phone = bundle.get("phone");
        if (accessToken != null && accessToken instanceof String) {
            token = (String)accessToken;
        } else if (refreshToken != null && refreshToken instanceof String) {
            token = (String)refreshToken;
        } else if (phone != null && phone instanceof String) {
            token = (String)phone;
        }
        String timestamp = CommonParamInterception.getTimestamp();
        paramBundle.putString("oauth_timestamp", timestamp);
        String oauthSign = HttpManager.getOauthSign(param.getContext(), aidInfo, token, appKey, timestamp);
        paramBundle.putString("oauth_sign", oauthSign);
        LogUtil.e("weiboSdk param", aidInfo + "  " + timestamp + "  " + appKey + "   " + token);
        return false;
    }

    private static String getTimestamp() {
        long timestamp = System.currentTimeMillis() / 1000L;
        return String.valueOf(timestamp);
    }
}

