/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.network.impl;

import android.os.AsyncTask;
import android.os.Bundle;
import com.sina.weibo.sdk.net.NetStateManager;
import com.sina.weibo.sdk.network.IRequestIntercept;
import com.sina.weibo.sdk.network.IRequestParam;
import com.sina.weibo.sdk.network.RequestCancelable;
import com.sina.weibo.sdk.network.base.RequestResult;
import com.sina.weibo.sdk.network.base.WbResponse;
import com.sina.weibo.sdk.network.exception.InterceptException;
import com.sina.weibo.sdk.network.exception.SdkException;
import com.sina.weibo.sdk.network.impl.RequestEngine;
import com.sina.weibo.sdk.network.intercept.GlobalInterceptHelper;
import com.sina.weibo.sdk.network.target.Target;
import com.sina.weibo.sdk.utils.LogUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class RequestTask<T, R>
extends AsyncTask<Object, Object, RequestResult>
implements RequestCancelable {
    private IRequestParam param;
    Class<T> tClass;
    private Target<R> target;

    public RequestTask(IRequestParam param, Target<R> target) {
        this.param = param;
        this.target = target;
    }

    protected RequestResult doInBackground(Object ... params) {
        RequestResult<R> requestResult = new RequestResult<R>();
        if (!NetStateManager.isNetworkConnected(this.param.getContext())) {
            LogUtil.e("Task", "RequestTask:android.permission.ACCESS_NETWORK_STATE");
            requestResult.setE(new SdkException("android.permission.ACCESS_NETWORK_STATE"));
        }
        if (this.param.needIntercept()) {
            try {
                Bundle bundle = new Bundle();
                HashMap<String, IRequestIntercept> globalIntercepts = GlobalInterceptHelper.init().getGlobalIntercept();
                for (String key : globalIntercepts.keySet()) {
                    IRequestIntercept iRequestIntercept = globalIntercepts.get(key);
                    if (iRequestIntercept == null || !iRequestIntercept.needIntercept(this.param, bundle)) continue;
                    iRequestIntercept.doIntercept(this.param, bundle);
                }
                ArrayList<IRequestIntercept> intercepts = this.param.getIntercept();
                for (IRequestIntercept intercept : intercepts) {
                    if (!intercept.needIntercept(this.param, bundle)) continue;
                    intercept.doIntercept(this.param, bundle);
                }
                this.param.getPostBundle().putAll(bundle);
            }
            catch (InterceptException e) {
                requestResult.setE(e);
                return requestResult;
            }
        }
        try {
            WbResponse response = RequestEngine.request(this.param);
            R tResult = this.target.transResponse(response);
            this.target.onRequestSuccessBg(tResult);
            requestResult.setResponse(tResult);
            try {
                InputStream is = response.body().byteStream();
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            requestResult.setE(e);
        }
        return requestResult;
    }

    protected void onPostExecute(RequestResult requestResult) {
        super.onPostExecute((Object)requestResult);
        if (this.target != null) {
            this.target.onRequestDone();
            if (requestResult.getE() != null) {
                this.target.onFailure(requestResult.getE());
                this.target.onError();
            } else {
                this.target.onRequestSuccess(requestResult.getResponse());
            }
        }
    }

    @Override
    public void cancelRequest() {
    }

    @Override
    public boolean isCancelRequest() {
        return false;
    }
}

