/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.network.impl;

import android.os.Bundle;
import com.sina.weibo.sdk.net.NetStateManager;
import com.sina.weibo.sdk.network.IRequestIntercept;
import com.sina.weibo.sdk.network.IRequestParam;
import com.sina.weibo.sdk.network.IRequestService;
import com.sina.weibo.sdk.network.RequestCancelable;
import com.sina.weibo.sdk.network.base.RequestResult;
import com.sina.weibo.sdk.network.base.WbResponse;
import com.sina.weibo.sdk.network.exception.InterceptException;
import com.sina.weibo.sdk.network.exception.RequestException;
import com.sina.weibo.sdk.network.exception.SdkException;
import com.sina.weibo.sdk.network.impl.FixRequestTask;
import com.sina.weibo.sdk.network.impl.RequestEngine;
import com.sina.weibo.sdk.network.intercept.GlobalInterceptHelper;
import com.sina.weibo.sdk.network.target.Target;
import com.sina.weibo.sdk.utils.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RequestService
implements IRequestService {
    private static IRequestService iRequestService;
    private ExecutorService fixedThreadPool;

    private RequestService() {
        GlobalInterceptHelper.init();
        this.fixedThreadPool = Executors.newFixedThreadPool(10);
    }

    public static IRequestService getInstance() {
        if (iRequestService == null) {
            iRequestService = new RequestService();
        }
        return iRequestService;
    }

    @Override
    public RequestResult request(IRequestParam param) throws RequestException {
        RequestResult<String> requestResult = new RequestResult<String>();
        if (!NetStateManager.isNetworkConnected(param.getContext())) {
            LogUtil.e("Task", "RequestService:\u7f51\u7edc\u8fde\u63a5\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u72b6\u6001");
            requestResult.setE(new SdkException("\u7f51\u7edc\u8fde\u63a5\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u72b6\u6001"));
        }
        if (param.needIntercept()) {
            try {
                Bundle bundle = new Bundle();
                HashMap<String, IRequestIntercept> globalIntercepts = GlobalInterceptHelper.init().getGlobalIntercept();
                for (String key : globalIntercepts.keySet()) {
                    IRequestIntercept iRequestIntercept = globalIntercepts.get(key);
                    if (iRequestIntercept == null || !iRequestIntercept.needIntercept(param, bundle)) continue;
                    iRequestIntercept.doIntercept(param, bundle);
                }
                ArrayList<IRequestIntercept> intercepts = param.getIntercept();
                for (IRequestIntercept intercept : intercepts) {
                    if (!intercept.needIntercept(param, bundle)) continue;
                    intercept.doIntercept(param, bundle);
                }
                param.getPostBundle().putAll(bundle);
                param.getGetBundle().putAll(bundle);
            }
            catch (InterceptException e) {
                requestResult.setE(e);
                return requestResult;
            }
        }
        try {
            WbResponse response = RequestEngine.request(param);
            requestResult.setResponse(String.valueOf(response.body().string()));
        }
        catch (Exception e) {
            requestResult.setE(e);
        }
        return requestResult;
    }

    @Override
    @Deprecated
    public <T> T request(IRequestParam param, Class<T> tClass) throws RequestException {
        return null;
    }

    @Override
    public <T> RequestCancelable asyncRequest(IRequestParam param, Target<T> tTarget) {
        FixRequestTask requestTask = new FixRequestTask(param, tTarget);
        this.fixedThreadPool.execute(requestTask);
        return null;
    }
}

