/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.network.impl;

import android.content.Context;
import android.os.Bundle;
import com.sina.weibo.sdk.network.IRequestIntercept;
import com.sina.weibo.sdk.network.IRequestParam;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RequestParam
implements IRequestParam {
    public static final String KEY_PARAM_BODY_BYTE_ARRAY = "body_byte_array";
    private String shortUrl;
    private Bundle getBundle = new Bundle();
    private Bundle postBundle = new Bundle();
    private Bundle headerBundle = new Bundle();
    private Bundle extraBundle = new Bundle();
    private IRequestParam.RequestType requestType;
    private boolean defaultHost;
    private Map<String, IRequestParam.ValuePart<File>> files = new HashMap<String, IRequestParam.ValuePart<File>>();
    private Map<String, byte[]> byteArrays = new HashMap<String, byte[]>();
    private ArrayList<IRequestIntercept> interceptList = new ArrayList();
    private Context appContext;
    private HashMap<String, Object> interceptResult;
    private boolean gZip = false;
    private int requestTimeout = 15000;
    private int responseTimeout = 15000;
    private boolean needIntercept = true;

    public RequestParam(Builder builder) {
        this.shortUrl = builder.shortUrl;
        this.getBundle.putAll(builder.getBundle);
        this.postBundle.putAll(builder.postBundle);
        this.requestType = builder.type;
        this.headerBundle.putAll(builder.headerBundle);
        this.extraBundle.putAll(builder.extraBundle);
        this.defaultHost = builder.defaultHost;
        this.files.putAll(builder.files);
        this.byteArrays.putAll(builder.byteArrays);
        this.needIntercept = builder.needIntercept;
        this.appContext = builder.appContext;
        this.interceptResult = new HashMap();
        this.interceptList = builder.interceptList;
        this.gZip = builder.gZip;
        this.requestTimeout = builder.requestTimeout;
        this.responseTimeout = builder.responseTimeout;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    @Override
    public boolean needGzip() {
        return false;
    }

    @Override
    public ArrayList<IRequestIntercept> getIntercept() {
        return this.interceptList;
    }

    @Override
    public void setUrl(String url) {
        this.shortUrl = url;
    }

    @Override
    public boolean needIntercept() {
        return this.needIntercept;
    }

    @Override
    public void addInterceptResult(String key, Object object) {
        this.interceptResult.put(key, object);
    }

    @Override
    public Object getInterceptResult(String key) {
        return this.interceptResult.get(key);
    }

    @Override
    public Bundle getExtraBundle() {
        return this.extraBundle;
    }

    @Override
    public Context getContext() {
        return this.appContext;
    }

    @Override
    public String getUrl() {
        return this.shortUrl;
    }

    @Override
    public Bundle getGetBundle() {
        return this.getBundle;
    }

    @Override
    public Bundle getPostBundle() {
        return this.postBundle;
    }

    @Override
    public IRequestParam.RequestType getMethod() {
        return this.requestType;
    }

    @Override
    public Bundle getHeader() {
        return this.headerBundle;
    }

    @Override
    public boolean useDefaultHost() {
        return this.defaultHost;
    }

    @Override
    public Map<String, IRequestParam.ValuePart<File>> files() {
        return this.files;
    }

    @Override
    public Map<String, byte[]> byteArrays() {
        return this.byteArrays;
    }

    public static final class Builder {
        String shortUrl;
        Bundle getBundle = new Bundle();
        Bundle postBundle = new Bundle();
        Bundle extraBundle = new Bundle();
        IRequestParam.RequestType type = IRequestParam.RequestType.POST;
        Bundle headerBundle = new Bundle();
        boolean defaultHost = true;
        ArrayList<IRequestIntercept> interceptList = new ArrayList();
        private Map<String, IRequestParam.ValuePart<File>> files = new HashMap<String, IRequestParam.ValuePart<File>>();
        private Map<String, byte[]> byteArrays = new HashMap<String, byte[]>();
        boolean needIntercept = true;
        Context appContext;
        boolean gZip = false;
        private int requestTimeout = 15000;
        private int responseTimeout = 15000;

        public Builder(Context context) {
            this.appContext = context;
        }

        public void setShortUrl(String url) {
            this.shortUrl = url;
        }

        public void addPostParam(String name, String value) {
            this.postBundle.putString(name, value);
        }

        public void addPostParam(String name, int value) {
            this.postBundle.putInt(name, value);
        }

        public void addPostParam(String name, long value) {
            this.postBundle.putLong(name, value);
        }

        public void addPostParam(Bundle bundle) {
            this.postBundle.putAll(bundle);
        }

        public void addIntercept(IRequestIntercept intercept) {
            this.interceptList.add(intercept);
        }

        public void addGetParam(String name, String value) {
            this.getBundle.putString(name, value);
        }

        public void addGetParam(String name, int value) {
            this.getBundle.putInt(name, value);
        }

        public void addGetParam(String name, long value) {
            this.getBundle.putLong(name, value);
        }

        public void addGetParam(Bundle bundle) {
            this.getBundle.putAll(bundle);
        }

        public void addExtParam(String name, String value) {
            this.extraBundle.putString(name, value);
        }

        public void addExtParam(String name, int value) {
            this.extraBundle.putInt(name, value);
        }

        public void setgZip(boolean flag) {
            this.gZip = flag;
        }

        public void addExtParam(String name, long value) {
            this.extraBundle.putLong(name, value);
        }

        public void addExtParam(Bundle bundle) {
            this.extraBundle.putAll(bundle);
        }

        public void addBodyParam(byte[] value) {
            this.postBundle.putByteArray(RequestParam.KEY_PARAM_BODY_BYTE_ARRAY, value);
        }

        public void addHeader(String key, String value) {
            this.headerBundle.putString(key, value);
        }

        public void setRequestTimeout(int time) {
            this.requestTimeout = time;
        }

        public void setResponseTimeout(int time) {
            this.responseTimeout = time;
        }

        public void setNeedIntercept(boolean needIntercept) {
            this.needIntercept = needIntercept;
        }

        public Builder addBodyParam(String key, File value, String mimeType) {
            IRequestParam.ValuePart filePart = new IRequestParam.ValuePart();
            filePart.value = value;
            filePart.mimeType = mimeType;
            this.files.put(key, filePart);
            return this;
        }

        public Builder addBodyParam(String key, byte[] value) {
            this.byteArrays.put(key, value);
            return this;
        }

        public void setRequestType(IRequestParam.RequestType type) {
            this.type = type;
        }

        public void defaultHostEnable(boolean enable) {
            this.defaultHost = enable;
        }

        public RequestParam build() {
            return new RequestParam(this);
        }
    }
}

