/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.network.impl;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import com.sina.weibo.sdk.net.NetStateManager;
import com.sina.weibo.sdk.network.IRequestParam;
import com.sina.weibo.sdk.network.base.RequestBodyHelper;
import com.sina.weibo.sdk.network.base.UriUtils;
import com.sina.weibo.sdk.network.base.WbResponse;
import com.sina.weibo.sdk.network.base.WbResponseBody;
import com.sina.weibo.sdk.network.exception.RequestException;
import com.sina.weibo.sdk.utils.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class RequestEngine {
    public static WbResponse request(IRequestParam param) throws RequestException {
        WbResponse wbResponse;
        block17: {
            String requestPath = param.getUrl();
            if (TextUtils.isEmpty((CharSequence)requestPath) || !requestPath.startsWith("http") && !requestPath.startsWith("https")) {
                throw new RequestException("\u975e\u6cd5\u7684\u8bf7\u6c42\u5730\u5740");
            }
            requestPath = UriUtils.buildCompleteUri(requestPath, param.getGetBundle());
            Pair<String, Integer> proxyData = NetStateManager.getAPN();
            Proxy proxy = null;
            if (proxyData != null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)proxyData.first, (int)((Integer)proxyData.second)));
            }
            InputStream inputStream = null;
            wbResponse = null;
            try {
                int connectCode;
                URL url = new URL(requestPath);
                HttpURLConnection urlConnection = "https".startsWith(requestPath) ? (proxy == null ? (HttpsURLConnection)url.openConnection() : (HttpsURLConnection)url.openConnection(proxy)) : (proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy));
                RequestEngine.setRequestHeader(urlConnection, param.getHeader());
                Bundle requestHeader = new Bundle();
                String boundary = RequestBodyHelper.getBoundry();
                boundary = "------------" + boundary;
                if (param.getMethod() == IRequestParam.RequestType.POST) {
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setRequestProperty("Connection", "Keep-Alive");
                    urlConnection.setRequestProperty("Charset", "UTF-8");
                    urlConnection.setUseCaches(false);
                    byte[] bytes = param.getPostBundle().getByteArray("body_byte_array");
                    if (bytes != null) {
                        requestHeader.putString("Content-Type", "application/octet-stream");
                    } else if (RequestBodyHelper.isMultipartRequest(param)) {
                        requestHeader.putString("Content-Type", "multipart/form-data;boundary=" + boundary);
                    } else {
                        requestHeader.putString("Content-Type", "application/x-www-form-urlencoded");
                    }
                    urlConnection.setDoInput(true);
                    urlConnection.setDoOutput(true);
                } else if (param.getMethod() == IRequestParam.RequestType.GET) {
                    urlConnection.setRequestMethod("GET");
                } else if (param.getMethod() == IRequestParam.RequestType.PATCH) {
                    urlConnection.setRequestMethod("PATCH");
                }
                urlConnection.setReadTimeout(param.getResponseTimeout());
                urlConnection.setConnectTimeout(param.getRequestTimeout());
                RequestEngine.setRequestHeader(urlConnection, requestHeader);
                urlConnection.connect();
                if (param.getMethod() != IRequestParam.RequestType.GET) {
                    RequestBodyHelper.fillRequestBody(param, urlConnection, boundary);
                }
                if ((connectCode = urlConnection.getResponseCode()) == 200) {
                    inputStream = urlConnection.getInputStream();
                    long length = urlConnection.getContentLength();
                    WbResponseBody responseBody = new WbResponseBody(inputStream, length);
                    wbResponse = new WbResponse(responseBody);
                    break block17;
                }
                if (connectCode == 302 || connectCode == 301) {
                    String location = urlConnection.getHeaderField("Location");
                    param.setUrl(location);
                    wbResponse = RequestEngine.request(param);
                    break block17;
                }
                inputStream = urlConnection.getErrorStream();
                long length = urlConnection.getContentLength();
                WbResponseBody responseBody = new WbResponseBody(inputStream, length);
                throw new RequestException("\u670d\u52a1\u5668\u5f02\u5e38" + responseBody.string());
            }
            catch (MalformedURLException e) {
                LogUtil.v("weibosdk", e.toString());
                throw new RequestException("\u8bf7\u6c42\u5f02\u5e38" + e.toString());
            }
            catch (IOException ie) {
                LogUtil.v("weibosdk", ie.toString());
                throw new RequestException("\u8bf7\u6c42\u5f02\u5e38" + ie.toString());
            }
        }
        return wbResponse;
    }

    private static void setRequestHeader(HttpURLConnection httpURLConnection, Bundle header) {
        if (header == null) {
            return;
        }
        for (String key : header.keySet()) {
            Object value = header.get(key);
            httpURLConnection.addRequestProperty(key, String.valueOf(value));
        }
    }
}

