/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.network.impl;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.sina.weibo.sdk.net.NetStateManager;
import com.sina.weibo.sdk.network.IRequestIntercept;
import com.sina.weibo.sdk.network.IRequestParam;
import com.sina.weibo.sdk.network.RequestCancelable;
import com.sina.weibo.sdk.network.base.RequestResult;
import com.sina.weibo.sdk.network.base.WbResponse;
import com.sina.weibo.sdk.network.exception.InterceptException;
import com.sina.weibo.sdk.network.exception.SdkException;
import com.sina.weibo.sdk.network.impl.RequestEngine;
import com.sina.weibo.sdk.network.intercept.GlobalInterceptHelper;
import com.sina.weibo.sdk.network.target.Target;
import com.sina.weibo.sdk.utils.LogUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class FixRequestTask<T, R>
implements Runnable,
RequestCancelable {
    private IRequestParam param;
    Class<T> tClass;
    private Target<R> target;
    private RequestCallback callback;

    public FixRequestTask(IRequestParam param, Target<R> target) {
        this.param = param;
        this.target = target;
        this.callback = new RequestCallback();
    }

    @Override
    public void run() {
        RequestResult<R> requestResult = new RequestResult<R>();
        if (!NetStateManager.isNetworkConnected(this.param.getContext())) {
            LogUtil.e("Task", "FixRequestTask:android.permission.ACCESS_NETWORK_STATE");
            requestResult.setE(new SdkException("android.permission.ACCESS_NETWORK_STATE"));
        }
        if (this.param.needIntercept()) {
            try {
                Bundle bundle = new Bundle();
                HashMap<String, IRequestIntercept> globalIntercepts = GlobalInterceptHelper.init().getGlobalIntercept();
                for (String key : globalIntercepts.keySet()) {
                    IRequestIntercept iRequestIntercept = globalIntercepts.get(key);
                    if (iRequestIntercept == null || !iRequestIntercept.needIntercept(this.param, bundle)) continue;
                    iRequestIntercept.doIntercept(this.param, bundle);
                }
                ArrayList<IRequestIntercept> intercepts = this.param.getIntercept();
                for (IRequestIntercept intercept : intercepts) {
                    if (!intercept.needIntercept(this.param, bundle)) continue;
                    intercept.doIntercept(this.param, bundle);
                }
                this.param.getGetBundle().putAll(bundle);
                this.param.getPostBundle().putAll(bundle);
            }
            catch (InterceptException e) {
                LogUtil.e("Task", "FixRequestTask:" + e.getMessage());
                requestResult.setE(e);
                Handler handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this.callback);
                Message message = new Message();
                message.obj = requestResult;
                handler.sendMessage(message);
                return;
            }
        }
        try {
            WbResponse response = RequestEngine.request(this.param);
            R tResult = this.target.transResponse(response);
            this.target.onRequestSuccessBg(tResult);
            requestResult.setResponse(tResult);
            try {
                InputStream is = response.body().byteStream();
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            requestResult.setE(e);
        }
        Handler handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this.callback);
        Message message = new Message();
        message.obj = requestResult;
        handler.sendMessage(message);
    }

    @Override
    public void cancelRequest() {
        this.run();
    }

    @Override
    public boolean isCancelRequest() {
        return false;
    }

    private class RequestCallback
    implements Handler.Callback {
        private RequestCallback() {
        }

        public boolean handleMessage(Message msg) {
            RequestResult requestResult = (RequestResult)msg.obj;
            if (FixRequestTask.this.target != null) {
                FixRequestTask.this.target.onRequestDone();
                if (requestResult.getE() != null) {
                    FixRequestTask.this.target.onFailure(requestResult.getE());
                    FixRequestTask.this.target.onError();
                } else {
                    FixRequestTask.this.target.onRequestSuccess(requestResult.getResponse());
                }
            }
            return false;
        }
    }
}

