/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.network.base;

import com.sina.weibo.sdk.network.exception.RequestException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WbResponseBody {
    private InputStream inputStream;
    private long length;

    public WbResponseBody(InputStream inputStream, long length) {
        this.inputStream = inputStream;
        this.length = length;
    }

    public String string() throws RequestException {
        byte[] result;
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = this.inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            this.inputStream.close();
            baos.close();
            result = baos.toByteArray();
        }
        catch (IOException e) {
            RequestException requestException = new RequestException(e.toString());
            throw requestException;
        }
        return new String(result);
    }

    public InputStream byteStream() {
        return this.inputStream;
    }

    public long contentLength() {
        return this.length;
    }
}

