/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.network.base;

import android.os.Bundle;
import com.sina.weibo.sdk.network.IRequestParam;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class RequestBodyHelper {
    private static final String OCTET_STREAM = "application/octet-stream";
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static void fillRequestBody(IRequestParam param, HttpURLConnection httpURLConnection, String boundary) throws IOException {
        byte[] bytes = param.getPostBundle().getByteArray("body_byte_array");
        OutputStream os = httpURLConnection.getOutputStream();
        DataOutputStream outputStream = new DataOutputStream(os);
        if (bytes != null) {
            if (param.needGzip()) {
                outputStream.write(RequestBodyHelper.transGzip(bytes));
            } else {
                outputStream.write(bytes);
            }
        } else if (RequestBodyHelper.isMultipartRequest(param)) {
            RequestBodyHelper.fillMultiBody(outputStream, param, boundary);
        } else {
            Bundle bundle = param.getPostBundle();
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String key : bundle.keySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("&");
                }
                try {
                    String value = String.valueOf(bundle.get(key));
                    sb.append(URLEncoder.encode(key, DEFAULT_CHARSET)).append("=").append(URLEncoder.encode(value, DEFAULT_CHARSET));
                }
                catch (Exception exception) {}
            }
            DataOutputStream dos = new DataOutputStream(outputStream);
            if (param.needGzip()) {
                dos.write(RequestBodyHelper.transGzip(sb.toString().getBytes(DEFAULT_CHARSET)));
            } else {
                dos.write(sb.toString().getBytes(DEFAULT_CHARSET));
            }
            dos.flush();
            dos.close();
        }
        os.flush();
        os.close();
    }

    public static boolean isMultipartRequest(IRequestParam param) {
        Map<String, IRequestParam.ValuePart<File>> files = param.files();
        Map<String, byte[]> byteArrays = param.byteArrays();
        return !files.isEmpty() || !byteArrays.isEmpty();
    }

    private static void fillMultiBody(OutputStream outputStream, IRequestParam param, String boundary) throws IOException {
        Bundle bundle = param.getPostBundle();
        String PREFIX = "--";
        String LINE_END = "\r\n";
        String CHARSET = "\"UTF-8\"";
        for (Object key : bundle.keySet()) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.setLength(0);
            stringBuilder.append(PREFIX);
            stringBuilder.append(boundary).append(LINE_END);
            stringBuilder.append("Content-Disposition: form-data; name=\"").append((String)key).append("\"").append(LINE_END);
            stringBuilder.append("Content-Type: text/plain;charset:" + CHARSET + LINE_END);
            stringBuilder.append("Content-Transfer-Encoding: 8bit").append(LINE_END);
            stringBuilder.append(LINE_END);
            stringBuilder.append(String.valueOf(bundle.get((String)key))).append(LINE_END);
            outputStream.write(stringBuilder.toString().getBytes(DEFAULT_CHARSET));
        }
        Map<String, IRequestParam.ValuePart<File>> files = param.files();
        for (String string : files.keySet()) {
            IRequestParam.ValuePart<File> valuePart = files.get(string);
            File file = (File)valuePart.value;
            String mimeType = valuePart.mimeType;
            StringBuffer sb = new StringBuffer();
            sb.append(PREFIX);
            sb.append(boundary);
            sb.append(LINE_END);
            sb.append("Content-Disposition: form-data; name=\"").append(string).append("\";").append("filename=\"").append(file.getName()).append("\"").append(LINE_END);
            sb.append("Content-Type: " + mimeType + ";charset:" + CHARSET + LINE_END);
            sb.append(LINE_END);
            outputStream.write(sb.toString().getBytes(DEFAULT_CHARSET));
            FileInputStream is = new FileInputStream(file);
            byte[] bytes = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)is).read(bytes)) != -1) {
                outputStream.write(bytes, 0, len);
            }
            ((InputStream)is).close();
            outputStream.write(LINE_END.getBytes());
        }
        Map<String, byte[]> bytes = param.byteArrays();
        for (String key : bytes.keySet()) {
            StringBuffer sb = new StringBuffer();
            sb.append(PREFIX);
            sb.append(boundary);
            sb.append(LINE_END);
            sb.append("Content-Disposition: form-data; name=\"").append(key).append("\"").append(LINE_END);
            sb.append("Content-Type: text/plain;charset:\"UTF-8\"" + LINE_END);
            sb.append(LINE_END);
            outputStream.write(sb.toString().getBytes());
            outputStream.write(bytes.get(key));
            outputStream.write(LINE_END.getBytes());
        }
        byte[] byArray = (PREFIX + boundary + "--" + LINE_END).getBytes();
        outputStream.write(byArray);
        outputStream.flush();
        outputStream.close();
    }

    private static byte[] transGzip(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(data);
            gzip.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return out.toByteArray();
    }

    public static String getBoundry() {
        StringBuffer sb = new StringBuffer();
        for (int t = 1; t < 12; ++t) {
            long time = System.currentTimeMillis() + (long)t;
            if (time % 3L == 0L) {
                sb.append((char)time % 9);
                continue;
            }
            if (time % 3L == 1L) {
                sb.append((char)(65L + time % 26L));
                continue;
            }
            sb.append((char)(97L + time % 26L));
        }
        return sb.toString();
    }
}

