/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Pair;
import com.sina.weibo.sdk.utils.LogUtil;

public class NetStateManager {
    private static Context mContext;
    public static NetState CUR_NETSTATE;

    public static Pair<String, Integer> getAPN() {
        Uri uri = Uri.parse((String)"content://telephony/carriers/preferapn");
        Cursor mCursor = null;
        if (null != mContext) {
            mCursor = mContext.getContentResolver().query(uri, null, null, null, null);
        }
        Pair pair = null;
        if (mCursor != null && mCursor.moveToFirst()) {
            String proxyStr = mCursor.getString(mCursor.getColumnIndex("proxy"));
            if (proxyStr != null && proxyStr.trim().length() > 0) {
                pair = new Pair((Object)proxyStr, (Object)80);
            }
            mCursor.close();
        }
        return pair;
    }

    public static boolean isNetworkConnected(Context context) {
        if (context == null) {
            LogUtil.e("Weibosdk", "unexpected null context in isNetworkConnected");
            return false;
        }
        PackageManager pm = context.getPackageManager();
        if (pm.checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName()) != 0) {
            return false;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = null;
        try {
            info = cm.getActiveNetworkInfo();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return info != null && info.isAvailable();
    }

    static {
        CUR_NETSTATE = NetState.Mobile;
    }

    public class NetStateReceive
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            mContext = context;
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                WifiInfo info = wifiManager.getConnectionInfo();
                if (!wifiManager.isWifiEnabled() || -1 == info.getNetworkId()) {
                    CUR_NETSTATE = NetState.Mobile;
                }
            }
        }
    }

    public static enum NetState {
        Mobile,
        WIFI,
        NOWAY;

    }
}

