/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.net;

import android.content.Context;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class HttpsHelper {
    private SSLSocketFactory mSSLSocketFactory;

    private SSLSocketFactory getSSLSocketFactory(Context context) {
        if (this.mSSLSocketFactory == null) {
            String kstype = KeyStore.getDefaultType();
            try {
                KeyStore keyStore = KeyStore.getInstance(kstype);
                keyStore.load(null, null);
                Certificate certificate = this.loadCertificate(context);
                keyStore.setCertificateEntry("get_global_ca", certificate);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                TrustManager[] trustManagers = new TrustManager[]{new CustomX509TrustManager(keyStore)};
                sslContext.init(null, trustManagers, null);
                this.mSSLSocketFactory = sslContext.getSocketFactory();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
        }
        return this.mSSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate loadCertificate(Context context) throws CertificateException, IOException {
        Certificate certificate;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try (BufferedInputStream inputStream = new BufferedInputStream(context.getAssets().open("weibocn.cer"));){
            certificate = certificateFactory.generateCertificate(inputStream);
        }
        return certificate;
    }

    private static class CustomX509TrustManager
    implements X509TrustManager {
        private List<X509TrustManager> mTrustManagers = new ArrayList<X509TrustManager>();

        public CustomX509TrustManager(KeyStore ... keyStores) {
            ArrayList<TrustManagerFactory> mFactory = new ArrayList<TrustManagerFactory>();
            try {
                TrustManagerFactory original = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                original.init((KeyStore)null);
                mFactory.add(original);
                for (KeyStore keyStore : keyStores) {
                    TrustManagerFactory additionalCerts = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    additionalCerts.init(keyStore);
                    mFactory.add(additionalCerts);
                }
                for (TrustManagerFactory tmf : mFactory) {
                    for (TrustManager tm : tmf.getTrustManagers()) {
                        if (!(tm instanceof X509TrustManager)) continue;
                        this.mTrustManagers.add((X509TrustManager)tm);
                    }
                }
                if (this.mTrustManagers.size() == 0) {
                    throw new RuntimeException("Couldn't find any X509TrustManagers");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            X509TrustManager trustManager = this.mTrustManagers.get(0);
            trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509TrustManager trustManager : this.mTrustManagers) {
                trustManager.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            for (X509TrustManager trustManager : this.mTrustManagers) {
                certificates.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
            }
            return certificates.toArray(new X509Certificate[certificates.size()]);
        }
    }
}

