/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.net;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.exception.WeiboHttpException;
import com.sina.weibo.sdk.net.ConnectionFactory;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.network.IRequestParam;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.Utility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.util.Set;

public class HttpManager {
    private static final String TAG = "HttpManager";
    private static final String BOUNDARY;
    private static final String MP_BOUNDARY;
    private static final String END_MP_BOUNDARY;

    public static String openUrl(Context context, String url, String method, WeiboParameters params) throws WeiboException {
        String result = HttpManager.requestHttpExecute(context, url, method, params);
        LogUtil.d(TAG, "Response : " + result);
        return result;
    }

    private static String requestHttpExecute(Context context, String url, String method, WeiboParameters params) {
        String response = null;
        HttpURLConnection httpURLConnection = null;
        try {
            HttpManager.setHttpCommonParam(context, params);
            if ("GET".equals(method)) {
                url = url + "?" + params.encodeUrl();
                httpURLConnection = ConnectionFactory.createConnect(url, context);
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setInstanceFollowRedirects(true);
                httpURLConnection.connect();
            } else {
                DataOutputStream dos;
                httpURLConnection = ConnectionFactory.createConnect(url, context);
                httpURLConnection.setInstanceFollowRedirects(true);
                httpURLConnection.connect();
                if (params.hasBinaryData()) {
                    dos = new DataOutputStream(httpURLConnection.getOutputStream());
                    HttpManager.buildParams(dos, params);
                    dos.flush();
                    dos.close();
                } else {
                    dos = new DataOutputStream(httpURLConnection.getOutputStream());
                    String postParam = params.encodeUrl();
                    dos.write(postParam.getBytes("UTF-8"));
                    dos.flush();
                    dos.close();
                }
            }
            int statusCode = httpURLConnection.getResponseCode();
            if (statusCode != 200) {
                response = HttpManager.readConnectResponse(httpURLConnection, true);
                throw new WeiboHttpException(response, statusCode);
            }
            response = HttpManager.readConnectResponse(httpURLConnection, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new WeiboException(e);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return response;
    }

    private static String readConnectResponse(HttpURLConnection connection, boolean error) {
        String result = null;
        InputStream inputStream = null;
        ByteArrayOutputStream content = null;
        try {
            int readBytes = 0;
            byte[] buffer = new byte[8192];
            inputStream = error ? connection.getErrorStream() : connection.getInputStream();
            content = new ByteArrayOutputStream();
            if (inputStream != null) {
                while ((readBytes = inputStream.read(buffer)) != -1) {
                    content.write(buffer, 0, readBytes);
                }
                result = new String(content.toByteArray(), "UTF-8");
            }
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (content != null) {
                    content.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private static void setHttpCommonParam(Context context, WeiboParameters params) {
        String aid = "";
        if (!TextUtils.isEmpty((CharSequence)params.getAppKey()) && !TextUtils.isEmpty((CharSequence)(aid = Utility.getAid(context, params.getAppKey())))) {
            params.put("aid", aid);
        }
        String timestamp = HttpManager.getTimestamp();
        params.put("oauth_timestamp", timestamp);
        String token = "";
        Object accessToken = params.get("access_token");
        Object refreshToken = params.get("refresh_token");
        Object phone = params.get("phone");
        if (accessToken != null && accessToken instanceof String) {
            token = (String)accessToken;
        } else if (refreshToken != null && refreshToken instanceof String) {
            token = (String)refreshToken;
        } else if (phone != null && phone instanceof String) {
            token = (String)phone;
        }
        String oauthSign = HttpManager.getOauthSign(context, aid, token, params.getAppKey(), timestamp);
        params.put("oauth_sign", oauthSign);
    }

    public static void fillCommonRequestParam(IRequestParam param) {
    }

    public static String openRedirectUrl4LocationUri(Context context, String url, String method, WeiboParameters params) {
        HttpURLConnection httpURLConnection = null;
        if (method.equals("GET")) {
            url = url.endsWith("?") ? url + params.encodeUrl() : url + "?" + params.encodeUrl();
            httpURLConnection = ConnectionFactory.createConnect(url, context);
        } else {
            httpURLConnection = ConnectionFactory.createConnect(url, context);
        }
        String redirectUrl = "";
        try {
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.connect();
            int statusCode = httpURLConnection.getResponseCode();
            if (statusCode == 302 || statusCode == 301) {
                redirectUrl = httpURLConnection.getHeaderField("Location");
            } else if (statusCode == 200) {
                redirectUrl = url;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return redirectUrl;
    }

    public static synchronized String downloadFile(Context context, String url, String saveDir, String fileName) throws WeiboException {
        File filePath;
        File savePathDir = new File(saveDir);
        if (!savePathDir.exists()) {
            savePathDir.mkdirs();
        }
        if ((filePath = new File(savePathDir, fileName)).exists()) {
            return filePath.getPath();
        }
        if (!URLUtil.isValidUrl((String)url)) {
            return "";
        }
        long tempFileLength = 0L;
        File tempFile = new File(saveDir, fileName + "_temp");
        HttpURLConnection httpURLConnection = ConnectionFactory.createConnect(url, context);
        httpURLConnection.setConnectTimeout(300000);
        httpURLConnection.setReadTimeout(300000);
        try {
            httpURLConnection.setRequestMethod("GET");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (tempFile.exists()) {
                tempFileLength = tempFile.length();
            } else {
                tempFile.createNewFile();
            }
            httpURLConnection.setRequestProperty("RANGE", "bytes=" + tempFileLength);
            long totalLength = 0L;
            long startPosition = 0L;
            int connectCode = httpURLConnection.getResponseCode();
            if (connectCode != 206) {
                if (connectCode == 200) {
                    totalLength = httpURLConnection.getContentLength();
                } else {
                    String result = HttpManager.readConnectResponse(httpURLConnection, true);
                    throw new WeiboHttpException(result, connectCode);
                }
            }
            InputStream inputStream = httpURLConnection.getInputStream();
            RandomAccessFile content = new RandomAccessFile(tempFile, "rw");
            content.seek(startPosition);
            byte[] sBuffer = new byte[1024];
            int readBytes = 0;
            while ((readBytes = inputStream.read(sBuffer)) != -1) {
                content.write(sBuffer, 0, readBytes);
            }
            content.close();
            inputStream.close();
            if (totalLength != 0L && tempFile.length() >= totalLength) {
                tempFile.renameTo(filePath);
                return filePath.getPath();
            }
            tempFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static void buildParams(OutputStream baos, WeiboParameters params) throws WeiboException {
        try {
            StringBuilder sb;
            Object value;
            Set<String> keys = params.keySet();
            for (String key : keys) {
                value = params.get(key);
                if (!(value instanceof String)) continue;
                sb = new StringBuilder(100);
                sb.setLength(0);
                sb.append(MP_BOUNDARY).append("\r\n");
                sb.append("content-disposition: form-data; name=\"").append(key).append("\"\r\n\r\n");
                sb.append(params.get(key)).append("\r\n");
                baos.write(sb.toString().getBytes());
            }
            for (String key : keys) {
                value = params.get(key);
                if (value instanceof Bitmap) {
                    sb = new StringBuilder();
                    sb.append(MP_BOUNDARY).append("\r\n");
                    sb.append("content-disposition: form-data; name=\"").append(key).append("\"; filename=\"file\"\r\n");
                    sb.append("Content-Type: application/octet-stream; charset=utf-8\r\n\r\n");
                    baos.write(sb.toString().getBytes());
                    Bitmap bmp = (Bitmap)value;
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                    byte[] bytes = stream.toByteArray();
                    baos.write(bytes);
                    baos.write("\r\n".getBytes());
                    continue;
                }
                if (!(value instanceof ByteArrayOutputStream)) continue;
                sb = new StringBuilder();
                sb.append(MP_BOUNDARY).append("\r\n");
                sb.append("content-disposition: form-data; name=\"").append(key).append("\"; filename=\"file\"\r\n");
                sb.append("Content-Type: application/octet-stream; charset=utf-8\r\n\r\n");
                baos.write(sb.toString().getBytes());
                ByteArrayOutputStream stream = (ByteArrayOutputStream)value;
                baos.write(stream.toByteArray());
                baos.write("\r\n".getBytes());
                stream.close();
            }
            baos.write(("\r\n" + END_MP_BOUNDARY).getBytes());
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
    }

    public static String getBoundry() {
        StringBuffer sb = new StringBuffer();
        for (int t = 1; t < 12; ++t) {
            long time = System.currentTimeMillis() + (long)t;
            if (time % 3L == 0L) {
                sb.append((char)time % 9);
                continue;
            }
            if (time % 3L == 1L) {
                sb.append((char)(65L + time % 26L));
                continue;
            }
            sb.append((char)(97L + time % 26L));
        }
        return sb.toString();
    }

    private static String getTimestamp() {
        long timestamp = System.currentTimeMillis() / 1000L;
        return String.valueOf(timestamp);
    }

    public static String getOauthSign(Context context, String aid, String accessToken, String appKey, String timestamp) {
        StringBuilder part1 = new StringBuilder("");
        if (!TextUtils.isEmpty((CharSequence)aid)) {
            part1.append(aid);
        }
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            part1.append(accessToken);
        }
        if (!TextUtils.isEmpty((CharSequence)appKey)) {
            part1.append(appKey);
        }
        return HttpManager.calcOauthSignNative(context, part1.toString(), timestamp);
    }

    private static native String calcOauthSignNative(Context var0, String var1, String var2);

    static {
        System.loadLibrary("weibosdkcore");
        BOUNDARY = HttpManager.getBoundry();
        MP_BOUNDARY = "--" + BOUNDARY;
        END_MP_BOUNDARY = "--" + BOUNDARY + "--";
    }
}

