/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.net;

import android.content.Context;
import android.os.AsyncTask;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.HttpManager;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;
import java.lang.reflect.Method;

public class AsyncWeiboRunner {
    private Context mContext;

    public AsyncWeiboRunner(Context context) {
        this.mContext = context;
    }

    @Deprecated
    public void requestByThread(final String url, final WeiboParameters params, final String httpMethod, final RequestListener listener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String resp = HttpManager.openUrl(AsyncWeiboRunner.this.mContext, url, httpMethod, params);
                    if (listener != null) {
                        listener.onComplete(resp);
                    }
                }
                catch (WeiboException e) {
                    if (listener != null) {
                        listener.onWeiboException(e);
                    }
                }
            }
        }.start();
    }

    public void request4RdirectURL(final String url, final WeiboParameters params, final String httpMethod, final RequestListener listener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String resp = HttpManager.openRedirectUrl4LocationUri(AsyncWeiboRunner.this.mContext, url, httpMethod, params);
                    if (listener != null) {
                        listener.onComplete(resp);
                    }
                }
                catch (WeiboException e) {
                    if (listener != null) {
                        listener.onWeiboException(e);
                    }
                }
            }
        }.start();
    }

    public String request(String url, WeiboParameters params, String httpMethod) throws WeiboException {
        this.addAction(this.mContext, params.getAppKey());
        return HttpManager.openUrl(this.mContext, url, httpMethod, params);
    }

    public String request(String appkey, boolean isAnonymous, String cookie, String url, WeiboParameters params, String httpMethod) throws WeiboException {
        if (isAnonymous) {
            params.put("source", appkey);
            params.setAnonymousCookie(cookie);
            return this.request(url, params, httpMethod);
        }
        return this.request(url, params, httpMethod);
    }

    public void requestAsync(String url, WeiboParameters params, String httpMethod, RequestListener listener) {
        this.addAction(this.mContext, params.getAppKey());
        new RequestRunner(this.mContext, url, params, httpMethod, listener).execute(new Void[]{null});
    }

    public void requestAsync(String appkey, boolean isAnonymous, String cookie, String url, WeiboParameters params, String httpMethod, RequestListener listener) {
        if (isAnonymous) {
            params.put("source", appkey);
            params.setAnonymousCookie(cookie);
            this.requestAsync(url, params, httpMethod, listener);
        } else {
            this.requestAsync(url, params, httpMethod, listener);
        }
    }

    private void addAction(Context context, String appId) {
        try {
            Class<?> wbActivator = Class.forName("com.sina.weibo.sdk.cmd.WbAppActivator");
            Method method = wbActivator.getMethod("getInstance", Context.class, String.class);
            Object object = method.invoke(null, context, appId);
            Method activateApp = object.getClass().getMethod("activateApp", new Class[0]);
            activateApp.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class AsyncTaskResult<T> {
        private T result;
        private WeiboException error;

        public T getResult() {
            return this.result;
        }

        public WeiboException getError() {
            return this.error;
        }

        public AsyncTaskResult(T result) {
            this.result = result;
        }

        public AsyncTaskResult(WeiboException error) {
            this.error = error;
        }
    }

    public static class RequestRunner
    extends AsyncTask<Void, Void, AsyncTaskResult<String>> {
        private final Context mContext;
        private final String mUrl;
        private final WeiboParameters mParams;
        private final String mHttpMethod;
        private final RequestListener mListener;

        public RequestRunner(Context context, String url, WeiboParameters params, String httpMethod, RequestListener listener) {
            this.mContext = context;
            this.mUrl = url;
            this.mParams = params;
            this.mHttpMethod = httpMethod;
            this.mListener = listener;
        }

        protected AsyncTaskResult<String> doInBackground(Void ... params) {
            try {
                String result = HttpManager.openUrl(this.mContext, this.mUrl, this.mHttpMethod, this.mParams);
                return new AsyncTaskResult<String>(result);
            }
            catch (WeiboException e) {
                LogUtil.e("ContentValues", e.getMessage());
                return new AsyncTaskResult<String>(e);
            }
        }

        protected void onPreExecute() {
        }

        protected void onPostExecute(AsyncTaskResult<String> result) {
            WeiboException exception = result.getError();
            if (exception != null) {
                this.mListener.onWeiboException(exception);
            } else {
                this.mListener.onComplete(result.getResult());
            }
        }
    }
}

