/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.WbSdk;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.auth.AccessTokenKeeper;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.auth.WbAppInfo;
import com.sina.weibo.sdk.auth.WbAuthListener;
import com.sina.weibo.sdk.auth.WbConnectErrorMessage;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.sso.WeiboSsoManager;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.NetworkHelper;
import com.sina.weibo.sdk.utils.SecurityHelper;
import com.sina.weibo.sdk.utils.UIUtils;
import com.sina.weibo.sdk.utils.Utility;
import com.sina.weibo.sdk.web.WebRequestType;
import com.sina.weibo.sdk.web.WeiboCallbackManager;
import com.sina.weibo.sdk.web.WeiboSdkWebActivity;
import com.sina.weibo.sdk.web.param.AuthWebViewRequestParam;

public class BaseSsoHandler {
    private static final String TAG = "BaseSsoHandler";
    protected Context mAuthActivity;
    protected WbAuthListener authListener;
    public static final String OAUTH2_BASE_URL = "https://open.weibo.cn/oauth2/authorize?";
    protected final int SSO_TYPE_INVALID = 3;
    protected int ssoRequestCode = -1;
    protected int ssoRequestType = 3;

    public BaseSsoHandler(Activity activity) {
        this.mAuthActivity = activity;
        WeiboSsoManager.getInstance().init((Context)activity, WbSdk.getAuthInfo().getAppKey());
    }

    public BaseSsoHandler(Context activity) {
        this.mAuthActivity = activity;
        WeiboSsoManager.getInstance().init(activity, WbSdk.getAuthInfo().getAppKey());
    }

    public void authorize(WbAuthListener listener) {
        this.authorize(32973, listener, AuthType.ALL);
    }

    public void authorizeClientSso(WbAuthListener listener) {
        this.authorize(32973, listener, AuthType.SsoOnly);
    }

    public void authorizeWeb(WbAuthListener listener) {
        this.authorize(32973, listener, AuthType.WebOnly);
    }

    private void authorize(int requestCode, WbAuthListener listener, AuthType authType) {
        this.resetIntentFillData();
        if (listener == null) {
            throw new RuntimeException("please set auth listener");
        }
        this.authListener = listener;
        if (authType == AuthType.WebOnly) {
            this.startWebAuth();
            return;
        }
        boolean onlyClientSso = false;
        if (authType == AuthType.SsoOnly) {
            onlyClientSso = true;
        }
        WbAppInfo wbAppInfo = WeiboAppManager.getInstance(this.mAuthActivity).getWbAppInfo();
        if (this.isWbAppInstalled() && wbAppInfo != null) {
            this.startClientAuth(requestCode);
        } else if (onlyClientSso) {
            this.authListener.onFailure(new WbConnectErrorMessage());
        } else {
            this.startWebAuth();
        }
    }

    protected void startClientAuth(int requestCode) {
        try {
            WbAppInfo wbAppInfo = WeiboAppManager.getInstance(this.mAuthActivity).getWbAppInfo();
            Intent intent = new Intent();
            intent.setClassName(wbAppInfo.getPackageName(), wbAppInfo.getAuthActivityName());
            intent.putExtras(WbSdk.getAuthInfo().getAuthBundle());
            intent.putExtra("_weibo_command_type", 3);
            intent.putExtra("_weibo_transaction", String.valueOf(System.currentTimeMillis()));
            intent.putExtra("aid", Utility.getAid(this.mAuthActivity, WbSdk.getAuthInfo().getAppKey()));
            if (!SecurityHelper.validateAppSignatureForIntent(this.mAuthActivity, intent)) {
                this.authListener.onFailure(new WbConnectErrorMessage("your install weibo app is counterfeit", "8001"));
                return;
            }
            this.fillExtraIntent(intent, requestCode);
            try {
                ((Activity)this.mAuthActivity).startActivityForResult(intent, this.ssoRequestCode);
            }
            catch (Exception e) {
                if (this.authListener != null) {
                    this.authListener.onFailure(new WbConnectErrorMessage());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void fillExtraIntent(Intent intent, int requestCode) {
    }

    protected void resetIntentFillData() {
        this.ssoRequestCode = 32973;
    }

    protected void startWebAuth() {
        AuthInfo authInfo = WbSdk.getAuthInfo();
        WeiboParameters requestParams = new WeiboParameters(authInfo.getAppKey());
        requestParams.put("client_id", authInfo.getAppKey());
        requestParams.put("redirect_uri", authInfo.getRedirectUrl());
        requestParams.put("scope", authInfo.getScope());
        requestParams.put("response_type", "code");
        requestParams.put("version", "0041005000");
        requestParams.put("luicode", "10000360");
        Oauth2AccessToken token = AccessTokenKeeper.readAccessToken(this.mAuthActivity);
        if (token != null && !TextUtils.isEmpty((CharSequence)token.getToken())) {
            requestParams.put("trans_token", token.getToken());
            requestParams.put("trans_access_token", token.getToken());
        }
        requestParams.put("lfid", "OP_" + authInfo.getAppKey());
        String aid = Utility.getAid(this.mAuthActivity, authInfo.getAppKey());
        if (!TextUtils.isEmpty((CharSequence)aid)) {
            requestParams.put("aid", aid);
        }
        requestParams.put("packagename", authInfo.getPackageName());
        requestParams.put("key_hash", authInfo.getKeyHash());
        String url = OAUTH2_BASE_URL + requestParams.encodeUrl();
        if (!NetworkHelper.hasInternetPermission(this.mAuthActivity)) {
            UIUtils.showAlert(this.mAuthActivity, "Error", "Application requires permission to access the Internet");
        } else {
            String mAuthListenerKey = null;
            if (this.authListener != null) {
                WeiboCallbackManager manager = WeiboCallbackManager.getInstance();
                mAuthListenerKey = manager.genCallbackKey();
                manager.setWeiboAuthListener(mAuthListenerKey, this.authListener);
            }
            AuthWebViewRequestParam param = new AuthWebViewRequestParam(authInfo, WebRequestType.AUTH, mAuthListenerKey, "\u5fae\u535a\u767b\u5f55", url, this.mAuthActivity);
            Intent intent = new Intent(this.mAuthActivity, WeiboSdkWebActivity.class);
            Bundle bundle = new Bundle();
            param.fillBundle(bundle);
            intent.putExtras(bundle);
            this.mAuthActivity.startActivity(intent);
        }
    }

    public void authorizeCallBack(int requestCode, int resultCode, Intent data) {
        if (32973 == requestCode) {
            if (resultCode == -1) {
                if (!SecurityHelper.checkResponseAppLegal(this.mAuthActivity, WeiboAppManager.getInstance(this.mAuthActivity).getWbAppInfo(), data)) {
                    this.authListener.onFailure(new WbConnectErrorMessage("your install weibo app is counterfeit", "8001"));
                    return;
                }
                String error = Utility.safeString(data.getStringExtra("error"));
                String error_type = Utility.safeString(data.getStringExtra("error_type"));
                String error_description = Utility.safeString(data.getStringExtra("error_description"));
                LogUtil.d(TAG, "error: " + error + ", error_type: " + error_type + ", error_description: " + error_description);
                if (TextUtils.isEmpty((CharSequence)error) && TextUtils.isEmpty((CharSequence)error_type) && TextUtils.isEmpty((CharSequence)error_description)) {
                    Bundle bundle = data.getExtras();
                    Oauth2AccessToken accessToken = Oauth2AccessToken.parseAccessToken(bundle);
                    if (accessToken != null && accessToken.isSessionValid()) {
                        LogUtil.d(TAG, "Login Success! " + accessToken.toString());
                        AccessTokenKeeper.writeAccessToken(this.mAuthActivity, accessToken);
                        this.authListener.onSuccess(accessToken);
                    }
                } else if ("access_denied".equals(error) || "OAuthAccessDeniedException".equals(error)) {
                    LogUtil.d(TAG, "Login canceled by user.");
                    this.authListener.cancel();
                } else {
                    LogUtil.d(TAG, "Login failed: " + error);
                    this.authListener.onFailure(new WbConnectErrorMessage(error_type, error_description));
                }
            } else if (resultCode == 0) {
                this.authListener.cancel();
            }
        }
    }

    @Deprecated
    public boolean isWbAppInstalled() {
        return WbSdk.isWbInstall(this.mAuthActivity);
    }

    protected static enum AuthType {
        ALL,
        SsoOnly,
        WebOnly;

    }
}

