/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.auth;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.sina.weibo.sdk.utils.Utility;
import java.io.Serializable;

public class AuthInfo
implements Parcelable,
Serializable {
    private String mAppKey = "";
    private String mRedirectUrl = "";
    private String mScope = "";
    private String mPackageName = "";
    private String mKeyHash = "";
    public static final Parcelable.Creator<AuthInfo> CREATOR = new Parcelable.Creator<AuthInfo>(){

        public AuthInfo createFromParcel(Parcel source) {
            return new AuthInfo(source);
        }

        public AuthInfo[] newArray(int size) {
            return new AuthInfo[size];
        }
    };

    public AuthInfo(Context context, String appKey, String redirectUrl, String scope) {
        this.mAppKey = appKey;
        this.mRedirectUrl = redirectUrl;
        this.mScope = scope;
        this.mPackageName = context.getPackageName();
        this.mKeyHash = Utility.getSign(context, this.mPackageName);
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public String getRedirectUrl() {
        return this.mRedirectUrl;
    }

    public String getScope() {
        return this.mScope;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getKeyHash() {
        return this.mKeyHash;
    }

    public Bundle getAuthBundle() {
        Bundle mBundle = new Bundle();
        mBundle.putString("appKey", this.mAppKey);
        mBundle.putString("redirectUri", this.mRedirectUrl);
        mBundle.putString("scope", this.mScope);
        mBundle.putString("packagename", this.mPackageName);
        mBundle.putString("key_hash", this.mKeyHash);
        return mBundle;
    }

    public static AuthInfo parseBundleData(Context context, Bundle data) {
        String appKey = data.getString("appKey");
        String redirectUrl = data.getString("redirectUri");
        String scope = data.getString("scope");
        return new AuthInfo(context, appKey, redirectUrl, scope);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mAppKey);
        dest.writeString(this.mRedirectUrl);
        dest.writeString(this.mScope);
        dest.writeString(this.mPackageName);
        dest.writeString(this.mKeyHash);
    }

    protected AuthInfo(Parcel in) {
        this.mAppKey = in.readString();
        this.mRedirectUrl = in.readString();
        this.mScope = in.readString();
        this.mPackageName = in.readString();
        this.mKeyHash = in.readString();
    }
}

