/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.auth;

import android.content.Context;
import android.content.SharedPreferences;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.network.IRequestService;
import com.sina.weibo.sdk.network.impl.RequestParam;
import com.sina.weibo.sdk.network.impl.RequestService;
import com.sina.weibo.sdk.network.target.SimpleTarget;

public class AccessTokenKeeper {
    private static final String PREFERENCES_NAME = "com_weibo_sdk_android";
    private static final String KEY_UID = "uid";
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_EXPIRES_IN = "expires_in";
    private static final String KEY_REFRESH_TOKEN = "refresh_token";

    public static void writeAccessToken(Context context, Oauth2AccessToken token) {
        if (null == context || null == token) {
            return;
        }
        SharedPreferences pref = context.getSharedPreferences(PREFERENCES_NAME, 32768);
        SharedPreferences.Editor editor = pref.edit();
        editor.putString(KEY_UID, token.getUid());
        editor.putString(KEY_ACCESS_TOKEN, token.getToken());
        editor.putString(KEY_REFRESH_TOKEN, token.getRefreshToken());
        editor.putLong(KEY_EXPIRES_IN, token.getExpiresTime());
        editor.commit();
    }

    public static Oauth2AccessToken readAccessToken(Context context) {
        if (null == context) {
            return null;
        }
        Oauth2AccessToken token = new Oauth2AccessToken();
        SharedPreferences pref = context.getSharedPreferences(PREFERENCES_NAME, 32768);
        token.setUid(pref.getString(KEY_UID, ""));
        token.setToken(pref.getString(KEY_ACCESS_TOKEN, ""));
        token.setRefreshToken(pref.getString(KEY_REFRESH_TOKEN, ""));
        token.setExpiresTime(pref.getLong(KEY_EXPIRES_IN, 0L));
        return token;
    }

    public static void clear(Context context) {
        if (null == context) {
            return;
        }
        SharedPreferences pref = context.getSharedPreferences(PREFERENCES_NAME, 32768);
        SharedPreferences.Editor editor = pref.edit();
        editor.clear();
        editor.commit();
    }

    public static void refreshToken(String appKey, final Context context, final RequestListener listener) {
        Oauth2AccessToken token = AccessTokenKeeper.readAccessToken(context);
        if (token == null) {
            return;
        }
        IRequestService requestService = RequestService.getInstance();
        RequestParam.Builder builder = new RequestParam.Builder(context);
        builder.setShortUrl("https://api.weibo.com/oauth2/access_token");
        builder.addPostParam("client_id", appKey);
        builder.addPostParam("appKey", appKey);
        builder.addPostParam("grant_type", KEY_REFRESH_TOKEN);
        builder.addPostParam(KEY_REFRESH_TOKEN, token.getRefreshToken());
        requestService.asyncRequest(builder.build(), new SimpleTarget(){

            @Override
            public void onSuccess(String response) {
                Oauth2AccessToken refreshToken = Oauth2AccessToken.parseAccessToken(response);
                AccessTokenKeeper.writeAccessToken(context, refreshToken);
                if (listener != null) {
                    listener.onComplete(response);
                }
            }

            @Override
            public void onFailure(Exception e) {
                if (listener != null) {
                    listener.onWeiboException(new WeiboException(e));
                }
            }
        });
    }
}

