/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api;

import android.os.Bundle;
import android.os.Parcelable;
import com.sina.weibo.sdk.api.BaseMediaObject;
import com.sina.weibo.sdk.api.ImageObject;
import com.sina.weibo.sdk.api.MultiImageObject;
import com.sina.weibo.sdk.api.TextObject;
import com.sina.weibo.sdk.api.VideoSourceObject;
import com.sina.weibo.sdk.utils.LogUtil;
import java.io.Serializable;

public final class WeiboMultiMessage
implements Serializable {
    private static final String TAG = "WeiboMultiMessage";
    public TextObject textObject;
    public ImageObject imageObject;
    public BaseMediaObject mediaObject;
    public MultiImageObject multiImageObject;
    public VideoSourceObject videoSourceObject;
    public int msgType;
    public static int OneImageType = 1;
    public static int NineImageType = 2;

    public WeiboMultiMessage() {
    }

    public WeiboMultiMessage(Bundle data) {
        this.toBundle(data);
    }

    public Bundle toBundle(Bundle data) {
        if (this.textObject != null) {
            data.putParcelable("_weibo_message_text", (Parcelable)this.textObject);
            data.putString("_weibo_message_text_extra", this.textObject.toExtraMediaString());
        } else {
            data.putParcelable("_weibo_message_text", null);
            data.putString("_weibo_message_text_extra", null);
        }
        if (this.imageObject != null) {
            data.putParcelable("_weibo_message_image", (Parcelable)this.imageObject);
            data.putString("_weibo_message_image_extra", this.imageObject.toExtraMediaString());
        } else {
            data.putParcelable("_weibo_message_image", null);
            data.putString("_weibo_message_image_extra", null);
        }
        if (this.mediaObject != null) {
            data.putParcelable("_weibo_message_media", (Parcelable)this.mediaObject);
            data.putString("_weibo_message_media_extra", this.mediaObject.toExtraMediaString());
        } else {
            data.putParcelable("_weibo_message_media", null);
            data.putString("_weibo_message_media_extra", null);
        }
        if (this.multiImageObject != null) {
            data.putParcelable("_weibo_message_multi_image", (Parcelable)this.multiImageObject);
        } else {
            data.putParcelable("_weibo_message_multi_image", null);
        }
        if (this.videoSourceObject != null) {
            data.putParcelable("_weibo_message_video_source", (Parcelable)this.videoSourceObject);
        } else {
            data.putParcelable("_weibo_message_video_source", null);
        }
        return data;
    }

    public WeiboMultiMessage toObject(Bundle data) {
        this.textObject = (TextObject)data.getParcelable("_weibo_message_text");
        if (this.textObject != null) {
            this.textObject.toExtraMediaObject(data.getString("_weibo_message_text_extra"));
        }
        this.imageObject = (ImageObject)data.getParcelable("_weibo_message_image");
        if (this.imageObject != null) {
            this.imageObject.toExtraMediaObject(data.getString("_weibo_message_image_extra"));
        }
        this.mediaObject = (BaseMediaObject)data.getParcelable("_weibo_message_media");
        if (this.mediaObject != null) {
            this.mediaObject.toExtraMediaObject(data.getString("_weibo_message_media_extra"));
        }
        this.multiImageObject = (MultiImageObject)data.getParcelable("_weibo_message_multi_image");
        this.videoSourceObject = (VideoSourceObject)data.getParcelable("_weibo_message_video_source");
        return this;
    }

    public boolean checkArgs() {
        if (this.textObject != null && !this.textObject.checkArgs()) {
            LogUtil.e(TAG, "checkArgs fail, textObject is invalid");
            return false;
        }
        if (this.imageObject != null && !this.imageObject.checkArgs()) {
            LogUtil.e(TAG, "checkArgs fail, imageObject is invalid");
            return false;
        }
        if (this.mediaObject != null && !this.mediaObject.checkArgs()) {
            LogUtil.e(TAG, "checkArgs fail, mediaObject is invalid");
            return false;
        }
        if (this.textObject == null && this.imageObject == null && this.mediaObject == null) {
            LogUtil.e(TAG, "checkArgs fail, textObject and imageObject and mediaObject is null");
            return false;
        }
        return true;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public int getMsgType() {
        return this.msgType;
    }
}

