/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.text.TextUtils;
import com.sina.weibo.sdk.ApiUtils;
import com.sina.weibo.sdk.auth.WbAppInfo;
import com.sina.weibo.sdk.utils.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.json.JSONObject;

public class WeiboAppManager {
    private static final String TAG = WeiboAppManager.class.getName();
    public static final String WEIBO_IDENTITY_ACTION = "com.sina.weibo.action.sdkidentity";
    private static final String SDK_INT_FILE_NAME = "weibo_for_sdk.json";
    private static final String WEIBO_PACKAGENAME = "com.sina.weibo";
    private static final String WEIBO_4G_PACKAGENAME = "com.sina.weibog3";
    private static WeiboAppManager sInstance;
    private Context mContext;
    private WbAppInfo wbAppInfo;

    private WeiboAppManager(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public static synchronized WeiboAppManager getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new WeiboAppManager(context);
        }
        return sInstance;
    }

    public synchronized WbAppInfo getWbAppInfo() {
        return WeiboAppManager.queryWbInfoInternal(this.mContext);
    }

    public static WbAppInfo queryWbInfoInternal(Context context) {
        return WeiboAppManager.queryWbInfoByAsset(context);
    }

    @Deprecated
    public boolean hasWbInstall() {
        Intent intent = new Intent(WEIBO_IDENTITY_ACTION);
        intent.addCategory("android.intent.category.DEFAULT");
        List list = this.mContext.getPackageManager().queryIntentServices(intent, 0);
        return list != null && !list.isEmpty();
    }

    private static WbAppInfo queryWbInfoByAsset(Context context) {
        Intent intent = new Intent(WEIBO_IDENTITY_ACTION);
        intent.addCategory("android.intent.category.DEFAULT");
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        if (list == null || list.isEmpty()) {
            return null;
        }
        WbAppInfo appInfo = null;
        for (ResolveInfo resolveInfo : list) {
            if (resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.applicationInfo == null || TextUtils.isEmpty((CharSequence)resolveInfo.serviceInfo.packageName)) continue;
            String packageName = resolveInfo.serviceInfo.packageName;
            WbAppInfo tempInfo = WeiboAppManager.parseWbInfoByAsset(context, packageName);
            if (tempInfo != null) {
                appInfo = tempInfo;
            }
            if (!WEIBO_PACKAGENAME.equals(packageName) && !WEIBO_4G_PACKAGENAME.equals(packageName)) continue;
            break;
        }
        return appInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WbAppInfo parseWbInfoByAsset(Context context, String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        InputStream is = null;
        try {
            int readNum;
            Context appContext = context.createPackageContext(packageName, 2);
            int bufferSize = 4096;
            byte[] buf = new byte[4096];
            is = appContext.getAssets().open(SDK_INT_FILE_NAME);
            StringBuilder sbContent = new StringBuilder();
            while ((readNum = is.read(buf, 0, 4096)) != -1) {
                sbContent.append(new String(buf, 0, readNum));
            }
            if (TextUtils.isEmpty((CharSequence)sbContent.toString()) || !ApiUtils.validateWeiboSign(context, packageName)) {
                // empty if block
            }
            JSONObject json = new JSONObject(sbContent.toString());
            int supportApi = json.optInt("support_api", -1);
            String authActivityName = json.optString("authActivityName", null);
            if (supportApi == -1 || TextUtils.isEmpty((CharSequence)authActivityName)) {
                WbAppInfo wbAppInfo = null;
                return wbAppInfo;
            }
            WbAppInfo wbAppInfo = new WbAppInfo();
            wbAppInfo.setPackageName(packageName);
            wbAppInfo.setSupportVersion(supportApi);
            wbAppInfo.setAuthActivityName(authActivityName);
            WbAppInfo wbAppInfo2 = wbAppInfo;
            return wbAppInfo2;
        }
        catch (Exception e) {
            LogUtil.e(TAG, e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

