/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.auth.WbAppInfo;
import com.sina.weibo.sdk.network.intercept.CommonParamInterception;
import com.sina.weibo.sdk.sso.WeiboSsoManager;
import java.util.List;

public class WbSdk {
    private static boolean init = false;
    private static AuthInfo authInfo;

    public static void install(Context context, AuthInfo info) {
        if (!init) {
            if (info == null || TextUtils.isEmpty((CharSequence)info.getAppKey()) || TextUtils.isEmpty((CharSequence)info.getRedirectUrl())) {
                throw new RuntimeException("please set right app info (appKey,redirect");
            }
            authInfo = info;
            CommonParamInterception.setAppKey(info.getAppKey());
            WeiboSsoManager.getInstance().init(context, info.getAppKey());
            init = true;
        }
    }

    public static void checkInit() {
        if (!init) {
            throw new RuntimeException("weibo sdk was not initall! please use: WbSdk.install() in your app Application or your main Activity. when you want to use weibo sdk function, make sure call WbSdk.install() before this function");
        }
    }

    public static AuthInfo getAuthInfo() {
        WbSdk.checkInit();
        return authInfo;
    }

    public static boolean isWbInstall(Context context) {
        Intent intent = new Intent("com.sina.weibo.action.sdkidentity");
        intent.addCategory("android.intent.category.DEFAULT");
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        return list != null && !list.isEmpty();
    }

    public static boolean supportMultiImage(Context context) {
        if (WbSdk.isWbInstall(context)) {
            WbAppInfo wbAppInfo = WeiboAppManager.getInstance(context).getWbAppInfo();
            return wbAppInfo != null && wbAppInfo.getSupportVersion() >= 10772;
        }
        return false;
    }
}

