/*
 * Decompiled with CFR 0.152.
 */
package com.sina.deviceidjnisdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;

public class DeviceInfo {
    @SuppressLint(value={"MissingPermission"})
    public static String getDeviceId(Context context) {
        String deviceId = null;
        if (DeviceInfo.isPermissionGranted(context, "android.permission.READ_PHONE_STATE")) {
            try {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                if (tm == null) {
                    return null;
                }
                deviceId = Build.VERSION.SDK_INT >= 23 ? tm.getDeviceId(0) : tm.getDeviceId();
                if (deviceId == null) {
                    deviceId = "";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                deviceId = "";
            }
        }
        if (deviceId == null) {
            deviceId = "";
        }
        return deviceId;
    }

    public static String getMacAddress(Context context) {
        String macAddress = null;
        if (DeviceInfo.isPermissionGranted(context, "android.permission.ACCESS_WIFI_STATE")) {
            try {
                WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
                if (wifiManager == null) {
                    return null;
                }
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                if (wifiInfo == null) {
                    return null;
                }
                macAddress = wifiInfo.getMacAddress();
            }
            catch (Exception e) {
                macAddress = "";
            }
        }
        if (macAddress == null) {
            macAddress = "";
        }
        return macAddress;
    }

    public static String getImei(Context context) {
        return DeviceInfo.getDeviceId(context);
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getImsi(Context context) {
        String imsi = "";
        if (DeviceInfo.isPermissionGranted(context, "android.permission.READ_PHONE_STATE")) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager == null) {
                return null;
            }
            imsi = telephonyManager.getSubscriberId();
        }
        if (imsi == null) {
            imsi = "";
        }
        return imsi;
    }

    private static boolean isPermissionGranted(Context context, String permName) {
        PackageManager pm = context.getPackageManager();
        return pm.checkPermission(permName, context.getPackageName()) == 0;
    }
}

