/*
 * Decompiled with CFR 0.152.
 */
package com.sina.deviceidjnisdk;

import android.content.Context;
import android.text.TextUtils;
import com.sina.deviceidjnisdk.DeviceId;
import com.sina.deviceidjnisdk.DeviceInfo;
import com.sina.deviceidjnisdk.IDeviceId;

public class DeviceIdFactory {
    private static volatile IDeviceId sInstance;

    private DeviceIdFactory() {
    }

    public static synchronized IDeviceId getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new DeviceId(context);
        }
        return sInstance;
    }

    public static synchronized String getIValue(Context context) {
        try {
            String deviceId = DeviceInfo.getDeviceId(context);
            if (TextUtils.isEmpty((CharSequence)deviceId)) {
                deviceId = DeviceInfo.getMacAddress(context);
            }
            if (TextUtils.isEmpty((CharSequence)deviceId)) {
                deviceId = "000000000000000";
            }
            if (!TextUtils.isEmpty((CharSequence)deviceId)) {
                return DeviceIdFactory.getIValueNative(context, deviceId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static native IDeviceId getInstanceNative(Context var0, int var1);

    public static native String calculateM(Context var0, String var1, String var2);

    private static native String getIValueNative(Context var0, String var1);

    static {
        System.loadLibrary("weibosdkcore");
    }
}

