/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.ssosdk;

import android.content.Context;
import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class WeiboSsoSdkConfig
implements Cloneable {
    private Context appContext;
    private String appKey = "";
    private String smid = "";
    private String from = "";
    private String wm = "";
    private String oldwm = "";
    private String sub = "";
    private String smApiKey = "";
    private HashMap<String, String> extra = new HashMap();

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public void addExtra(String key, String value) {
        this.extra.put(key, value);
    }

    public String getExtraString(boolean urlencode) {
        if (this.extra.isEmpty()) {
            return "";
        }
        JSONObject jsonObj = new JSONObject();
        for (Map.Entry<String, String> entry : this.extra.entrySet()) {
            try {
                jsonObj.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException e) {
                return "";
            }
        }
        if (urlencode) {
            return this.urlEncode(jsonObj.toString());
        }
        return jsonObj.toString();
    }

    public String getSub(boolean urlencode) {
        if (urlencode) {
            return this.urlEncode(this.sub);
        }
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public String getWm(boolean urlencode) {
        if (urlencode) {
            return this.urlEncode(this.wm);
        }
        return this.wm;
    }

    public void setWm(String wm) {
        this.wm = wm;
    }

    public String getOldWm(boolean urlencode) {
        if (urlencode) {
            return this.urlEncode(this.oldwm);
        }
        return this.oldwm;
    }

    public void setOldWm(String wm) {
        this.oldwm = wm;
    }

    public String getFrom(boolean urlencode) {
        if (urlencode) {
            return this.urlEncode(this.from);
        }
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getAppKey(boolean urlencode) {
        if (urlencode) {
            return this.urlEncode(this.appKey);
        }
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Context getApplicationContext() {
        return this.appContext;
    }

    public void setContext(Context ctx) {
        this.appContext = ctx.getApplicationContext();
    }

    public String getSmid(boolean urlencode) {
        if (urlencode) {
            return this.urlEncode(this.smid);
        }
        return this.smid;
    }

    public void setSmid(String smid) {
        this.smid = smid;
    }

    public void setSmApiKey(String apikey) {
        this.smApiKey = apikey;
    }

    public String getSmApiKey() {
        return this.smApiKey;
    }

    public boolean verify() {
        return this.appContext != null && !TextUtils.isEmpty((CharSequence)this.appKey) && !TextUtils.isEmpty((CharSequence)this.from) && !TextUtils.isEmpty((CharSequence)this.wm);
    }

    public Object clone() {
        WeiboSsoSdkConfig cfg;
        try {
            cfg = (WeiboSsoSdkConfig)super.clone();
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : cfg.extra.entrySet()) {
                tmp.put(entry.getKey(), entry.getValue());
            }
            cfg.extra = tmp;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return cfg;
    }
}

