/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.ssosdk;

import android.text.TextUtils;
import com.weibo.ssosdk.MfpBuilder;
import com.weibo.ssosdk.WeiboSsoSdkConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

public class WeiboSsoSdk {
    private static final String LOGIN_URL = "https://login.sina.com.cn/visitor/signin";
    private static final int SDK_ACT_VISITORLOGIN = 1;
    private static final int SDK_ACT_UPLOAD = 2;
    public static final String SDK_VERSION_CODE = "1.0";
    private static final String TAG = "WeiboSsoSdk";
    private volatile ReentrantLock mTaskLock = new ReentrantLock(true);
    private static final int VERSION = 1;
    private static final String AID_FILE_NAME = "weibo_sso_sdk_aid";
    private static final String INIT_FILE_NAME = "weibo_sso_sdk_init";
    private static WeiboSsoSdk sInstance;
    private static WeiboSsoSdkConfig config;
    private boolean isFirstUpload = true;
    private VisitorLoginInfo mVisitorLoginInfo;
    private int mCallCount;

    private WeiboSsoSdk() throws Exception {
        if (config == null || !config.verify()) {
            throw new Exception("config error");
        }
        this.mCallCount = 0;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(86400000L);
                            String aid = "";
                            aid = WeiboSsoSdk.this.mVisitorLoginInfo != null && !TextUtils.isEmpty((CharSequence)WeiboSsoSdk.this.mVisitorLoginInfo.getAid()) ? WeiboSsoSdk.this.mVisitorLoginInfo.getAid() : WeiboSsoSdk.this.loadAidFromCache();
                            WeiboSsoSdk.getInstance().updateInfo(aid, 2);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(60000L);
                    if (!WeiboSsoSdk.this.isFirstUpload) {
                        return;
                    }
                    String aid = WeiboSsoSdk.this.mVisitorLoginInfo != null && !TextUtils.isEmpty((CharSequence)WeiboSsoSdk.this.mVisitorLoginInfo.getAid()) ? WeiboSsoSdk.this.mVisitorLoginInfo.getAid() : WeiboSsoSdk.this.loadAidFromCache();
                    WeiboSsoSdk.this.updateInfo(aid, 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public static synchronized boolean initConfig(WeiboSsoSdkConfig cfg) {
        if (cfg == null) {
            return false;
        }
        if (!cfg.verify()) {
            return false;
        }
        if (config == null) {
            config = (WeiboSsoSdkConfig)cfg.clone();
            MfpBuilder.init(config.getApplicationContext());
            return true;
        }
        return false;
    }

    public static synchronized WeiboSsoSdk getInstance() throws Exception {
        if (sInstance == null) {
            sInstance = new WeiboSsoSdk();
        }
        return sInstance;
    }

    public void updateSub(String sub) {
        if (TextUtils.isEmpty((CharSequence)sub)) {
            return;
        }
        config.setSub(sub);
        String visitorSub = this.mVisitorLoginInfo.getVisitorSub();
        if (TextUtils.isEmpty((CharSequence)visitorSub) || !visitorSub.equals(sub)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String aid = WeiboSsoSdk.this.mVisitorLoginInfo != null && !TextUtils.isEmpty((CharSequence)WeiboSsoSdk.this.mVisitorLoginInfo.getAid()) ? WeiboSsoSdk.this.mVisitorLoginInfo.getAid() : WeiboSsoSdk.this.loadAidFromCache();
                    try {
                        WeiboSsoSdk.this.updateInfo(aid, 2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }
    }

    private static void LogD(String msg) {
    }

    private static void LogE(String msg) {
    }

    private String do_post(String data) {
        String msg = null;
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(LOGIN_URL).openConnection();
            conn.setRequestMethod("POST");
            conn.setReadTimeout(3000);
            conn.setConnectTimeout(1000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            OutputStream out = conn.getOutputStream();
            out.write(data.getBytes());
            out.flush();
            int code = conn.getResponseCode();
            if (code == 200) {
                InputStream is = conn.getInputStream();
                ByteArrayOutputStream message = new ByteArrayOutputStream();
                int len = 0;
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    message.write(buffer, 0, len);
                }
                is.close();
                message.close();
                msg = new String(message.toByteArray());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    private void updateInfo(String aid, int act) throws Exception {
        if (TextUtils.isEmpty((CharSequence)config.getAppKey(false))) {
            return;
        }
        if (!this.mTaskLock.tryLock()) {
            this.mTaskLock.lock();
            this.mTaskLock.unlock();
            return;
        }
        this.isFirstUpload = false;
        String mfp = MfpBuilder.getMfp(config.getApplicationContext());
        try {
            aid = URLEncoder.encode(aid, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            aid = "";
        }
        String packageName = config.getApplicationContext().getPackageName();
        String data = this.riseWind(config.getAppKey(true), packageName, aid, mfp, config.getFrom(true), config.getOldWm(true), config.getWm(true), config.getSub(true), config.getSmid(true), config.getExtraString(true), act, this.mCallCount);
        String response = this.do_post(data);
        ++this.mCallCount;
        if (response != null) {
            VisitorLoginInfo visitorLoginInfo = null;
            try {
                visitorLoginInfo = VisitorLoginInfo.parseJson(response);
            }
            catch (Exception e) {
                this.mTaskLock.unlock();
                throw e;
            }
            if (visitorLoginInfo != null && !TextUtils.isEmpty((CharSequence)visitorLoginInfo.getAid())) {
                this.cacheAidInfo(visitorLoginInfo.getAid());
            }
            if (act == 1) {
                this.mVisitorLoginInfo = visitorLoginInfo;
            }
        } else {
            this.mTaskLock.unlock();
            throw new Exception("network error.");
        }
        this.mTaskLock.unlock();
    }

    public VisitorLoginInfo visitorLogin() throws Exception {
        if (this.mVisitorLoginInfo == null) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        WeiboSsoSdk.this.updateInfo("", 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            t.start();
            t.join();
        }
        if (this.mVisitorLoginInfo == null) {
            throw new Exception("visitor login failed");
        }
        return this.mVisitorLoginInfo;
    }

    public String getAid() throws Exception {
        String aid = this.loadAidFromCache();
        if (!TextUtils.isEmpty((CharSequence)aid)) {
            return aid;
        }
        if (this.mVisitorLoginInfo == null || TextUtils.isEmpty((CharSequence)this.mVisitorLoginInfo.getAid())) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        WeiboSsoSdk.this.updateInfo("", 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            t.start();
            t.join();
        }
        if (this.mVisitorLoginInfo == null) {
            throw new Exception("visitor login failed");
        }
        return this.mVisitorLoginInfo.getAid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadAidFromCache() {
        FileInputStream fis = null;
        try {
            File aidFile = this.getAidInfoFile(1);
            fis = new FileInputStream(aidFile);
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            String string = new String(buffer);
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    private File getAidInfoFile(int version) {
        File dir = config.getApplicationContext().getFilesDir();
        File aidFile = new File(dir, AID_FILE_NAME + version);
        return aidFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cacheAidInfo(String aid) {
        if (TextUtils.isEmpty((CharSequence)aid)) {
            return;
        }
        FileOutputStream fos = null;
        try {
            File aidFile = this.getAidInfoFile(1);
            fos = new FileOutputStream(aidFile);
            fos.write(aid.getBytes());
        }
        catch (Exception exception) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadInitFile() {
        FileInputStream fis = null;
        try {
            File initFile = this.getInitFile();
            fis = new FileInputStream(initFile);
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            String string = new String(buffer);
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private File getInitFile() {
        File dir = config.getApplicationContext().getFilesDir();
        File aidFile = new File(dir, INIT_FILE_NAME);
        return aidFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveInitFile(String smid) {
        if (TextUtils.isEmpty((CharSequence)smid)) {
            return;
        }
        FileOutputStream fos = null;
        try {
            File aidFile = this.getInitFile();
            fos = new FileOutputStream(aidFile);
            fos.write(smid.getBytes());
        }
        catch (Exception exception) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private native String riseWind(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, int var11, int var12);

    static {
        System.loadLibrary("wind");
    }

    public static final class VisitorLoginInfo {
        private String mAid;
        private String mSubCookie;

        public String getAid() {
            return this.mAid;
        }

        public String getVisitorSub() {
            return this.mSubCookie;
        }

        static VisitorLoginInfo parseJson(String response) throws Exception {
            VisitorLoginInfo instance = new VisitorLoginInfo();
            JSONObject resObj = new JSONObject(response);
            String retcode = resObj.optString("retcode", "");
            JSONObject data = resObj.getJSONObject("data");
            if (!retcode.equals("20000000") || data == null) {
                throw new Exception("error\uff1a " + retcode + " msg:" + resObj.optString("msg", ""));
            }
            instance.mAid = data.optString("aid", "");
            instance.mSubCookie = data.optString("sub", "");
            return instance;
        }

        VisitorLoginInfo cloneAidInfo() {
            VisitorLoginInfo visitorLoginInfo = new VisitorLoginInfo();
            visitorLoginInfo.mAid = this.mAid;
            visitorLoginInfo.mSubCookie = this.mSubCookie;
            return visitorLoginInfo;
        }
    }
}

