/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.ssosdk;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import javax.crypto.Cipher;
import org.json.JSONException;
import org.json.JSONObject;

public class MfpBuilder {
    private static final String TAG = "MfpBuilder";
    public static final String AID_TAG = "weibo_aid_value";

    private static void LogD(String msg) {
    }

    private static void LogE(String msg) {
    }

    public static void init(Context ctx) {
    }

    public static String getMfp(Context ctx) {
        String mfpJson = MfpBuilder.genMfpString(ctx);
        String mfpJsonUtf8 = "";
        try {
            mfpJsonUtf8 = new String(mfpJson.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return mfpJsonUtf8;
    }

    private static String generateUAAid(Context ctx) {
        StringBuilder buffer = new StringBuilder();
        String packageName = ctx.getPackageName();
        String sdkFlag = "ssosdk";
        if (!TextUtils.isEmpty((CharSequence)packageName) && packageName.contains("com.sina.weibo")) {
            sdkFlag = "weibo";
        }
        buffer.append(Build.MANUFACTURER).append("-").append(Build.MODEL);
        buffer.append("__");
        buffer.append(sdkFlag);
        buffer.append("__");
        try {
            String versionCode = "1.0";
            buffer.append(versionCode.replaceAll("\\s+", "_"));
        }
        catch (Exception localE) {
            buffer.append("unknown");
        }
        buffer.append("__").append("android").append("__android").append(Build.VERSION.RELEASE);
        return buffer.toString();
    }

    private static String genMfpString(Context ctx) {
        JSONObject mfpObj = new JSONObject();
        try {
            String connectType;
            String deviceName;
            String bssid;
            String ssid;
            String resolution;
            String sdcard;
            String model;
            String cpu;
            String androidId;
            String serial;
            String iccid;
            String mac;
            String imsi;
            String meid;
            String imei;
            String os = MfpBuilder.getOS();
            if (!TextUtils.isEmpty((CharSequence)os)) {
                mfpObj.put("os", (Object)os);
            }
            if (!TextUtils.isEmpty((CharSequence)(imei = MfpBuilder.getImei(ctx)))) {
                mfpObj.put("imei", (Object)imei);
            }
            if (!TextUtils.isEmpty((CharSequence)(meid = MfpBuilder.getMeid(ctx)))) {
                mfpObj.put("meid", (Object)meid);
            }
            if (!TextUtils.isEmpty((CharSequence)(imsi = MfpBuilder.getImsi(ctx)))) {
                mfpObj.put("imsi", (Object)imsi);
            }
            if (!TextUtils.isEmpty((CharSequence)(mac = MfpBuilder.getMac(ctx)))) {
                mfpObj.put("mac", (Object)mac);
            }
            if (!TextUtils.isEmpty((CharSequence)(iccid = MfpBuilder.getIccid(ctx)))) {
                mfpObj.put("iccid", (Object)iccid);
            }
            if (!TextUtils.isEmpty((CharSequence)(serial = MfpBuilder.getSerialNo()))) {
                mfpObj.put("serial", (Object)serial);
            }
            if (!TextUtils.isEmpty((CharSequence)(androidId = MfpBuilder.getAndroidId(ctx)))) {
                mfpObj.put("androidid", (Object)androidId);
            }
            if (!TextUtils.isEmpty((CharSequence)(cpu = MfpBuilder.getCpu()))) {
                mfpObj.put("cpu", (Object)cpu);
            }
            if (!TextUtils.isEmpty((CharSequence)(model = MfpBuilder.getModel()))) {
                mfpObj.put("model", (Object)model);
            }
            if (!TextUtils.isEmpty((CharSequence)(sdcard = MfpBuilder.getSdSize()))) {
                mfpObj.put("sdcard", (Object)sdcard);
            }
            if (!TextUtils.isEmpty((CharSequence)(resolution = MfpBuilder.getResolution(ctx)))) {
                mfpObj.put("resolution", (Object)resolution);
            }
            if (!TextUtils.isEmpty((CharSequence)(ssid = MfpBuilder.getSsid(ctx)))) {
                mfpObj.put("ssid", (Object)ssid);
            }
            if (!TextUtils.isEmpty((CharSequence)(bssid = MfpBuilder.getWifiBssid(ctx)))) {
                mfpObj.put("bssid", (Object)bssid);
            }
            if (!TextUtils.isEmpty((CharSequence)(deviceName = MfpBuilder.getDeviceName()))) {
                mfpObj.put("deviceName", (Object)deviceName);
            }
            if (!TextUtils.isEmpty((CharSequence)(connectType = MfpBuilder.getConnectType(ctx)))) {
                mfpObj.put("connecttype", (Object)connectType);
            }
            String ua = "";
            try {
                ua = MfpBuilder.generateUAAid(ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!TextUtils.isEmpty((CharSequence)ua)) {
                mfpObj.put("ua", (Object)ua);
            }
            double batteryCapacity = MfpBuilder.getBatteryCapacity(ctx);
            mfpObj.put("batterymaxcapacity", (Object)String.valueOf(batteryCapacity));
            mfpObj.put("batterycurrentcapacity", (Object)String.valueOf(batteryCapacity));
            BatteryInfo batteryInfo = new BatteryInfo(ctx);
            mfpObj.put("batterycurrentvoltage", batteryInfo.getVoltage());
            mfpObj.put("batterycurrenttemperature", batteryInfo.getTemperature());
            mfpObj.put("batterycurrentcapacity", batteryCapacity * (double)batteryInfo.getLevel() / (double)batteryInfo.getScale());
            return mfpObj.toString();
        }
        catch (JSONException jSONException) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encryptRsa(String src, String publicKeyStr) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        PublicKey publicKey = MfpBuilder.getPublicKey(publicKeyStr);
        cipher.init(1, publicKey);
        ByteArrayOutputStream bos = null;
        byte[] plainText = src.getBytes("UTF-8");
        try {
            byte[] enBytes;
            bos = new ByteArrayOutputStream();
            int len = 0;
            int offset = 0;
            while ((len = MfpBuilder.splite(plainText, offset, 117)) != -1) {
                enBytes = cipher.doFinal(plainText, offset, len);
                bos.write(enBytes);
                offset += len;
            }
            bos.flush();
            enBytes = bos.toByteArray();
            byte[] base64byte = Base64.encode((byte[])enBytes, (int)2);
            String VERSION2 = "01";
            String base64string = new String(base64byte, "UTF-8");
            String string = base64string = "01" + base64string;
            return string;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int splite(byte[] src, int offset, int limit) {
        if (offset >= src.length) {
            return -1;
        }
        int delta = src.length - offset;
        return Math.min(delta, limit);
    }

    private static PublicKey getPublicKey(String key) throws Exception {
        byte[] keyBytes = Base64.decode((byte[])key.getBytes(), (int)2);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    private static String getOS() {
        try {
            return "Android " + Build.VERSION.RELEASE;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getImei(Context ctx) {
        try {
            TelephonyManager telePhonyMgr = (TelephonyManager)ctx.getSystemService("phone");
            return telePhonyMgr.getDeviceId();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getMeid(Context ctx) {
        try {
            TelephonyManager telePhonyMgr = (TelephonyManager)ctx.getSystemService("phone");
            return telePhonyMgr.getDeviceId();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getImsi(Context ctx) {
        try {
            TelephonyManager telePhonyMgr = (TelephonyManager)ctx.getSystemService("phone");
            return telePhonyMgr.getSubscriberId();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String bytesToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (byte b : bytes) {
            buf.append(String.format("%02X:", b));
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    private static String getMacAddr() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return "";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static String getMac(Context ctx) {
        if (Build.VERSION.SDK_INT >= 23) {
            return MfpBuilder.getMacAddr();
        }
        try {
            WifiManager wifi = (WifiManager)ctx.getSystemService("wifi");
            if (null == wifi) {
                return "";
            }
            WifiInfo info = wifi.getConnectionInfo();
            return info != null ? info.getMacAddress() : "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getIccid(Context ctx) {
        try {
            TelephonyManager telePhonyMgr = (TelephonyManager)ctx.getSystemService("phone");
            return telePhonyMgr.getSimSerialNumber();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getSerialNo() {
        String serialnum = "";
        if (Build.VERSION.SDK_INT >= 26) {
            return MfpBuilder.getSerialNoForO();
        }
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class, String.class);
            serialnum = (String)get.invoke(c, "ro.serialno", "unknown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serialnum;
    }

    private static double getBatteryCapacity(Context context) {
        Object mPowerProfile_ = null;
        String POWER_PROFILE_CLASS = "com.android.internal.os.PowerProfile";
        try {
            mPowerProfile_ = Class.forName("com.android.internal.os.PowerProfile").getConstructor(Context.class).newInstance(context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            double batteryCapacity = (Double)Class.forName("com.android.internal.os.PowerProfile").getMethod("getAveragePower", String.class).invoke(mPowerProfile_, "battery.capacity");
            return batteryCapacity;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    @TargetApi(value=26)
    private static String getSerialNoForO() {
        String serialNo = "";
        try {
            serialNo = Build.getSerial();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serialNo;
    }

    private static String getAndroidId(Context ctx) {
        try {
            String androidId = Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)"android_id");
            return androidId;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getCpu() {
        try {
            return Build.CPU_ABI;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getModel() {
        try {
            return Build.MODEL;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getSdSize() {
        try {
            File path = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long availableBlocks = stat.getBlockCount();
            return Long.toString(availableBlocks * blockSize);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getResolution(Context ctx) {
        try {
            DisplayMetrics dm = new DisplayMetrics();
            WindowManager wm = (WindowManager)ctx.getSystemService("window");
            wm.getDefaultDisplay().getMetrics(dm);
            return String.valueOf(dm.widthPixels) + "*" + String.valueOf(dm.heightPixels);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getSsid(Context ctx) {
        WifiManager wifiManager = (WifiManager)ctx.getApplicationContext().getSystemService("wifi");
        try {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            if (wifiInfo != null) {
                return wifiInfo.getSSID();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getWifiBssid(Context ctx) {
        WifiManager wifi = (WifiManager)ctx.getApplicationContext().getSystemService("wifi");
        try {
            WifiInfo wifiInfo = wifi.getConnectionInfo();
            if (wifiInfo != null) {
                String bssidAdress = wifiInfo.getBSSID();
                return bssidAdress;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return "";
    }

    private static String getDeviceName() {
        try {
            return Build.BRAND;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getConnectType(Context ctx) {
        String network = "none";
        try {
            ConnectivityManager connectivity = (ConnectivityManager)ctx.getSystemService("connectivity");
            NetworkInfo info = connectivity.getActiveNetworkInfo();
            if (null != info) {
                if (info.getType() == 0) {
                    switch (info.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            network = "2G";
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            network = "3G";
                            break;
                        }
                        case 13: {
                            network = "4G";
                            break;
                        }
                        default: {
                            network = "none";
                            break;
                        }
                    }
                } else if (info.getType() == 1) {
                    network = "wifi";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return network;
    }

    private static final class BatteryInfo {
        private Intent batteryInfoIntent;

        private BatteryInfo(Context context) {
            this.batteryInfoIntent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }

        private int getStatus() {
            return this.batteryInfoIntent.getIntExtra("status", 0);
        }

        private int getHealth() {
            return this.batteryInfoIntent.getIntExtra("health", 1);
        }

        private boolean getPresent() {
            return this.batteryInfoIntent.getBooleanExtra("present", false);
        }

        private int getLevel() {
            return this.batteryInfoIntent.getIntExtra("level", 0);
        }

        private int getScale() {
            return this.batteryInfoIntent.getIntExtra("scale", 0);
        }

        private int getPlugged() {
            return this.batteryInfoIntent.getIntExtra("plugged", 0);
        }

        private int getVoltage() {
            return this.batteryInfoIntent.getIntExtra("voltage", 0);
        }

        private int getTemperature() {
            return this.batteryInfoIntent.getIntExtra("temperature", 0);
        }

        private String getTechnology() {
            return this.batteryInfoIntent.getStringExtra("technology");
        }
    }
}

