/*
 * Decompiled with CFR 0.152.
 */
package g.toutiao;

import android.app.Activity;
import android.content.Context;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.bytedance.ttgame.core.SdkEngine;
import com.bytedance.ttgame.framework.module.callback.ICallback;
import com.bytedance.ttgame.module.pay.api.I18nPayInfo;
import com.bytedance.ttgame.module.pay.api.IPayService;
import com.bytedance.ttgame.module.pay.api.PayCallback;
import com.bytedance.ttgame.module.pay.api.PayResult;
import com.bytedance.ttgame.module.pay.api.ProductInfo;
import com.bytedance.ttgame.module.pay.api.ProductList;
import com.bytedance.ttgame.module.secure.api.ISecureService;
import com.bytedance.ttgame.rocketapi.Rocket;
import com.bytedance.ttgame.rocketapi.pay.IPayCallback;
import com.bytedance.ttgame.rocketapi.pay.IQueryProductsCallback;
import com.bytedance.ttgame.rocketapi.pay.QueryGoodsParams;
import com.bytedance.ttgame.rocketapi.pay.RocketGoods;
import com.bytedance.ttgame.rocketapi.pay.RocketPayInfo;
import com.bytedance.ttgame.rocketapi.pay.RocketPayResult;
import com.bytedance.ttgame.rocketapi.pay.RocketProductInfo;
import g.main.auh;
import g.main.aui;
import g.main.aul;
import g.main.aun;
import g.main.auo;
import g.main.aup;
import g.toutiao.uy;
import g.toutiao.uz;
import g.toutiao.va;
import g.toutiao.vc;
import g.toutiao.vd;
import g.toutiao.vf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

public class vb {
    public static final String TAG = "{PayService}";
    private Context mContext;
    private IPayCallback<RocketPayResult> oJ;
    private IPayCallback<RocketPayResult> oK;
    private IPayCallback<RocketGoods> oL;
    private aul oM;
    private va oN;
    private aui oO;
    private Map<String, ProductInfo> oP = new HashMap<String, ProductInfo>();
    private volatile boolean oQ;
    private long mStartTime;

    public void fetchProducts() {
        if (this.oN != null) {
            this.oN.release();
        }
        this.oN = new va();
        this.oN.fetchProducts(new ICallback<vc>(){

            public void onSuccess(@Nullable vc vc2) {
                if (vc2 != null && vc2.products != null && !vc2.products.isEmpty()) {
                    ArrayList<vd> arrayList = new ArrayList<vd>();
                    ArrayList<vd> arrayList2 = new ArrayList<vd>();
                    for (vd vd2 : vc2.products) {
                        if (vd2.isSubscription()) {
                            arrayList2.add(vd2);
                            continue;
                        }
                        arrayList.add(vd2);
                    }
                    vb.this.a(arrayList, arrayList2);
                }
            }

            public void onFailed(@Nullable vc vc2) {
            }
        });
    }

    private void a(List<vd> list, ArrayList<vd> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>(list.size());
        ArrayList<String> arrayList3 = new ArrayList<String>(list.size());
        for (vd vd2 : list) {
            if (vd2 == null) continue;
            arrayList2.add(vd2.getProductId());
        }
        for (vd vd2 : arrayList) {
            if (vd2 == null) continue;
            arrayList3.add(vd2.getProductId());
        }
        IPayService iPayService = (IPayService)SdkEngine.getInstance().getComponent(IPayService.class);
        iPayService.queryProductDetails(arrayList2, new ICallback<ProductList>(){

            public void onSuccess(@Nullable ProductList productList) {
                if (productList != null && productList.getProductInfoList() != null && !productList.getProductInfoList().isEmpty()) {
                    for (ProductInfo productInfo : productList.getProductInfoList()) {
                        if (productInfo == null) continue;
                        vb.this.oP.put(productInfo.getProductId(), productInfo);
                    }
                }
            }

            public void onFailed(@Nullable ProductList productList) {
            }
        });
        iPayService.querySubscriptionDetails(arrayList3, new ICallback<ProductList>(){

            public void onSuccess(@Nullable ProductList productList) {
                if (productList != null && productList.getProductInfoList() != null && !productList.getProductInfoList().isEmpty()) {
                    for (ProductInfo productInfo : productList.getProductInfoList()) {
                        if (productInfo == null) continue;
                        vb.this.oP.put(productInfo.getProductId(), productInfo);
                    }
                }
            }

            public void onFailed(@Nullable ProductList productList) {
            }
        });
    }

    public void pay(Activity activity, RocketPayInfo rocketPayInfo, IPayCallback<RocketPayResult> iPayCallback) {
        this.a(rocketPayInfo);
        if (this.oQ) {
            Timber.tag((String)TAG).i("current is requesting create order, ignore current request..", new Object[0]);
            return;
        }
        this.oQ = true;
        this.mContext = activity;
        this.oJ = iPayCallback;
        if (this.oM != null) {
            this.oM.release();
        }
        auh.d((RocketPayInfo)rocketPayInfo);
        this.oM = new aul();
        aun aun2 = new aun("bsdkintl", rocketPayInfo);
        ProductInfo productInfo = this.oP.get(rocketPayInfo.getProductId());
        if (productInfo != null) {
            Timber.tag((String)TAG).i("ProductInfo is not null", new Object[0]);
            long l2 = productInfo.getPriceAmountMicros() / 10000L;
            aun2.cy(l2);
            aun2.iV(productInfo.getCurrency());
        } else {
            Timber.tag((String)TAG).e("ProductInfo is null", new Object[0]);
            this.fetchProducts();
        }
        aup aup2 = new aup(aun2.getProductId(), aun2.getSdkOpenId());
        aup2.FQ();
        this.oM.a((Context)activity, aun2, (ICallback)new a(aup2, rocketPayInfo));
        ((ISecureService)Rocket.getInstance().getComponent(ISecureService.class)).reportNow("pay");
    }

    private void a(Context context, final RocketPayInfo rocketPayInfo, final I18nPayInfo i18nPayInfo) {
        if (i18nPayInfo == null) {
            Timber.tag((String)TAG).d("payinfo is null, ignore to pay.", new Object[0]);
            return;
        }
        this.a(rocketPayInfo, i18nPayInfo);
        this.mStartTime = SystemClock.uptimeMillis();
        IPayService iPayService = (IPayService)SdkEngine.getInstance().getComponent(IPayService.class);
        final vf vf2 = new vf(i18nPayInfo.getProductId(), i18nPayInfo.getOrderId());
        vf2.beginMonitorGooglePay();
        final ProductInfo productInfo = this.oP.get(i18nPayInfo.getProductId());
        iPayService.pay(context, i18nPayInfo, new ICallback<PayResult>(){

            public void onSuccess(@Nullable PayResult payResult) {
                IPayCallback iPayCallback;
                rocketPayInfo.setDuration((int)(SystemClock.uptimeMillis() - vb.this.mStartTime));
                vf2.monitorGooglePaySuccess();
                RocketPayResult rocketPayResult = RocketPayResult.newSuccessPayResult();
                if (payResult != null) {
                    rocketPayResult.setGameOrderId(payResult.getOrderId());
                    rocketPayResult.setGameProductId(payResult.getProductId());
                    vb.this.a(i18nPayInfo, productInfo, rocketPayInfo);
                }
                if ((iPayCallback = vb.this.oJ) != null) {
                    iPayCallback.onSuccess((Object)rocketPayResult);
                }
            }

            public void onFailed(PayResult payResult) {
                rocketPayInfo.setDuration((int)(SystemClock.uptimeMillis() - vb.this.mStartTime));
                RocketPayResult rocketPayResult = RocketPayResult.newChannelErrorPayResult((int)payResult.getCode(), (String)payResult.getMsg());
                rocketPayResult.setGameOrderId(payResult.getOrderId());
                rocketPayResult.setGameProductId(payResult.getProductId());
                vb.this.a(payResult, i18nPayInfo, rocketPayInfo);
                int n2 = payResult.getCode();
                if (n2 == 206) {
                    vf2.monitorGooglePayCancel();
                } else {
                    vf2.monitorGooglePayFail(n2, payResult.getMsg());
                }
                IPayCallback iPayCallback = vb.this.oJ;
                if (iPayCallback != null) {
                    iPayCallback.onFailed((Object)rocketPayResult);
                }
            }
        });
    }

    private void a(RocketPayInfo rocketPayInfo) {
        auh.c((RocketPayInfo)rocketPayInfo);
    }

    private void a(PayResult payResult, I18nPayInfo i18nPayInfo, RocketPayInfo rocketPayInfo) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("order_id", (Object)i18nPayInfo.getOrderId());
            jSONObject.put("amount", rocketPayInfo.getAmount());
            jSONObject.put("pay_type", (Object)"google_play");
            jSONObject.put("error_code", (Object)String.valueOf(payResult.getCode()));
            jSONObject.put("detail_code", (Object)String.valueOf(payResult.getDetailCode()));
            jSONObject.put("error_msg", (Object)payResult.getMsg());
            auh.g((RocketPayInfo)rocketPayInfo, (JSONObject)jSONObject);
        }
        catch (JSONException jSONException) {
            Timber.tag((String)TAG).e(jSONException.getLocalizedMessage(), new Object[0]);
        }
    }

    private void a(RocketPayInfo rocketPayInfo, I18nPayInfo i18nPayInfo) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("amount", rocketPayInfo.getAmount());
            jSONObject.put("order_id", (Object)i18nPayInfo.getOrderId());
            auh.e((RocketPayInfo)rocketPayInfo, (JSONObject)jSONObject);
        }
        catch (JSONException jSONException) {
            Timber.tag((String)TAG).e(jSONException.getLocalizedMessage(), new Object[0]);
        }
    }

    private void a(I18nPayInfo i18nPayInfo, ProductInfo productInfo, RocketPayInfo rocketPayInfo) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("order_id", (Object)i18nPayInfo.getOrderId());
            jSONObject.put("amount", rocketPayInfo.getAmount());
            jSONObject.put("pay_type", (Object)"google_play");
            jSONObject.put("real_pay_amount", productInfo == null ? 0L : productInfo.getPriceAmountMicros() / 10000L);
            jSONObject.put("real_pay_currency", (Object)(productInfo == null ? "" : productInfo.getCurrency()));
            auh.f((RocketPayInfo)rocketPayInfo, (JSONObject)jSONObject);
        }
        catch (JSONException jSONException) {
            Timber.tag((String)TAG).e(jSONException.getLocalizedMessage(), new Object[0]);
        }
    }

    public void queryProductDetails(List<String> list, final IQueryProductsCallback iQueryProductsCallback) {
        Timber.tag((String)TAG).i("queryProductDetails, productIds: %s", new Object[]{list});
        IPayService iPayService = (IPayService)SdkEngine.getInstance().getComponent(IPayService.class);
        iPayService.queryProductDetails(list, new ICallback<ProductList>(){

            public void onSuccess(@Nullable ProductList productList) {
                if (iQueryProductsCallback == null) {
                    Timber.tag((String)vb.TAG).i("queryProductDetails success, but callback is null", new Object[0]);
                    return;
                }
                if (productList != null && productList.getProductInfoList() != null) {
                    Timber.tag((String)vb.TAG).i("queryProductDetails success", new Object[0]);
                    List list = vb.this.transform(productList.getProductInfoList());
                    iQueryProductsCallback.onSuccess(list);
                }
            }

            public void onFailed(@Nullable ProductList productList) {
                if (iQueryProductsCallback == null) {
                    Timber.tag((String)vb.TAG).i("queryProductDetails failed, but callback is null", new Object[0]);
                    return;
                }
                if (productList != null) {
                    Timber.tag((String)vb.TAG).i("queryProductDetails failed, errorCode: %d, errorMsg:%s", new Object[]{productList.getCode(), productList.getMessage()});
                    iQueryProductsCallback.onFailed(productList.getCode(), productList.getMessage());
                }
            }
        });
    }

    public void receivePreregisterAwards(final Context context, final RocketPayInfo rocketPayInfo, final IPayCallback<RocketPayResult> iPayCallback) {
        this.oK = iPayCallback;
        IPayService iPayService = (IPayService)SdkEngine.getInstance().getComponent(IPayService.class);
        iPayService.queryPreregisterAwards(new PayCallback<List<String>>(){

            @Override
            public void onSuccess(@Nullable List<String> list) {
                Timber.tag((String)vb.TAG).v("query preregister awards, result:%s", new Object[]{list});
                if (list == null || list.isEmpty()) {
                    if (iPayCallback != null) {
                        iPayCallback.onFailed((Object)RocketPayResult.newChannelErrorPayResult((int)1001, (String)"dones't have preregister awards."));
                    }
                    return;
                }
                rocketPayInfo.setProductId(list.get(0));
                vb.this.a(rocketPayInfo);
                aul aul2 = new aul();
                aun aun2 = new aun("bsdkintl", rocketPayInfo);
                ProductInfo productInfo = (ProductInfo)vb.this.oP.get(rocketPayInfo.getProductId());
                if (productInfo != null) {
                    Timber.tag((String)vb.TAG).i("ProductInfo is not null", new Object[0]);
                    long l2 = productInfo.getPriceAmountMicros() / 10000L;
                    aun2.cy(l2);
                    aun2.iV(productInfo.getCurrency());
                }
                aup aup2 = new aup(aun2.getProductId(), aun2.getSdkOpenId());
                aup2.FQ();
                Context context2 = context.getApplicationContext();
                aul2.a(context2, aun2, (ICallback)new b(aup2, rocketPayInfo));
                ((ISecureService)Rocket.getInstance().getComponent(ISecureService.class)).reportNow("pay");
            }

            @Override
            public void onFailed(int n2, String string2) {
                if (iPayCallback != null) {
                    RocketPayResult rocketPayResult = RocketPayResult.newChannelErrorPayResult((int)n2, (String)string2);
                    iPayCallback.onFailed((Object)rocketPayResult);
                }
            }
        });
    }

    private void b(final RocketPayInfo rocketPayInfo, final I18nPayInfo i18nPayInfo) {
        if (i18nPayInfo == null) {
            Timber.tag((String)TAG).d("i18nPayInfo is null, ignore to pay.", new Object[0]);
            return;
        }
        this.a(rocketPayInfo, i18nPayInfo);
        this.mStartTime = SystemClock.uptimeMillis();
        IPayService iPayService = (IPayService)SdkEngine.getInstance().getComponent(IPayService.class);
        final vf vf2 = new vf(i18nPayInfo.getProductId(), i18nPayInfo.getOrderId());
        vf2.beginMonitorGooglePay();
        final ProductInfo productInfo = this.oP.get(i18nPayInfo.getProductId());
        iPayService.receivePreregisterAwards(i18nPayInfo, new ICallback<PayResult>(){

            public void onSuccess(PayResult payResult) {
                rocketPayInfo.setDuration((int)(SystemClock.uptimeMillis() - vb.this.mStartTime));
                vf2.monitorGooglePaySuccess();
                RocketPayResult rocketPayResult = RocketPayResult.newSuccessPayResult();
                rocketPayResult.setGameOrderId(payResult.getOrderId());
                rocketPayResult.setGameProductId(payResult.getProductId());
                vb.this.a(i18nPayInfo, productInfo, rocketPayInfo);
                IPayCallback iPayCallback = vb.this.oK;
                if (iPayCallback != null) {
                    iPayCallback.onSuccess((Object)rocketPayResult);
                }
            }

            public void onFailed(PayResult payResult) {
                rocketPayInfo.setDuration((int)(SystemClock.uptimeMillis() - vb.this.mStartTime));
                RocketPayResult rocketPayResult = RocketPayResult.newChannelErrorPayResult((int)payResult.getCode(), (String)payResult.getMsg());
                rocketPayResult.setGameOrderId(payResult.getOrderId());
                rocketPayResult.setGameProductId(payResult.getProductId());
                vb.this.a(payResult, i18nPayInfo, rocketPayInfo);
                vf2.monitorGooglePayFail(payResult.getCode(), payResult.getMsg());
                IPayCallback iPayCallback = vb.this.oK;
                if (iPayCallback != null) {
                    iPayCallback.onFailed((Object)rocketPayResult);
                }
            }
        });
    }

    public void release() {
        this.mContext = null;
        this.oQ = false;
        this.oJ = null;
        this.oL = null;
        if (this.oM != null) {
            this.oM.release();
            this.oM = null;
        }
        if (this.oN != null) {
            this.oN.release();
            this.oN = null;
        }
        if (this.oO != null) {
            this.oO.release();
            this.oO = null;
        }
    }

    public void registerExtraPayCallback(final IPayCallback<RocketPayResult> iPayCallback) {
        IPayService iPayService = (IPayService)SdkEngine.getInstance().getComponent(IPayService.class);
        if (iPayService != null) {
            iPayService.setExtraPayCallback(new ICallback<PayResult>(){

                public void onSuccess(@Nullable PayResult payResult) {
                    if (iPayCallback != null && payResult != null) {
                        RocketPayResult rocketPayResult = RocketPayResult.newSuccessPayResult();
                        rocketPayResult.setGameOrderId(payResult.getOrderId());
                        rocketPayResult.setGameProductId(payResult.getProductId());
                        iPayCallback.onSuccess((Object)rocketPayResult);
                    }
                }

                public void onFailed(@Nullable PayResult payResult) {
                    if (iPayCallback != null && payResult != null) {
                        RocketPayResult rocketPayResult = RocketPayResult.newChannelErrorPayResult((int)payResult.getCode(), (String)payResult.getMsg());
                        rocketPayResult.setGameOrderId(payResult.getOrderId());
                        rocketPayResult.setGameProductId(payResult.getProductId());
                        iPayCallback.onFailed((Object)rocketPayResult);
                    }
                }
            });
        }
    }

    public void queryGoodsWithActivity(Context context, final QueryGoodsParams queryGoodsParams, IPayCallback<RocketGoods> iPayCallback) {
        if (context == null) {
            Timber.tag((String)TAG).w("context = null, ignore queryGoodsWithActivity.", new Object[0]);
            return;
        }
        this.oL = iPayCallback;
        this.oO = new aui();
        this.oO.a(context, queryGoodsParams, null, (ICallback)new ICallback<RocketGoods>(){

            public void onSuccess(@Nullable RocketGoods rocketGoods) {
                if (rocketGoods != null && rocketGoods.isSuccess() && rocketGoods.getRocketGoods() != null) {
                    if (queryGoodsParams.isDoCurrencyAdapt()) {
                        vb.this.a(rocketGoods);
                    } else if (vb.this.oL != null) {
                        vb.this.oL.onSuccess((Object)rocketGoods);
                        vb.this.oL = null;
                    }
                } else if (vb.this.oL != null) {
                    vb.this.oL.onFailed((Object)rocketGoods);
                    vb.this.oL = null;
                }
            }

            public void onFailed(@Nullable RocketGoods rocketGoods) {
                if (vb.this.oL != null) {
                    vb.this.oL.onFailed((Object)rocketGoods);
                    vb.this.oL = null;
                }
            }
        });
    }

    private void a(RocketGoods rocketGoods) {
        uy.mergeGoods(rocketGoods, (Function0<Unit>)((Function0)() -> {
            if (this.oL == null) {
                return null;
            }
            this.oL.onSuccess((Object)rocketGoods);
            this.oL = null;
            return null;
        }));
    }

    private List<RocketProductInfo> transform(List<ProductInfo> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<RocketProductInfo>();
        }
        ArrayList<RocketProductInfo> arrayList = new ArrayList<RocketProductInfo>(list.size());
        for (ProductInfo productInfo : list) {
            if (productInfo == null) continue;
            RocketProductInfo rocketProductInfo = new RocketProductInfo(productInfo.getProductId(), productInfo.getPrice(), productInfo.getCurrency(), productInfo.getPriceAmountMicros());
            arrayList.add(rocketProductInfo);
        }
        return arrayList;
    }

    class b
    extends a {
        public b(aup aup2, RocketPayInfo rocketPayInfo) {
            super(aup2, rocketPayInfo);
        }

        @Override
        protected void c(RocketPayInfo rocketPayInfo, I18nPayInfo i18nPayInfo) {
            vb.this.b(rocketPayInfo, i18nPayInfo);
        }

        @Override
        protected void a(RocketPayResult rocketPayResult) {
            IPayCallback iPayCallback = vb.this.oK;
            if (iPayCallback != null) {
                iPayCallback.onFailed((Object)rocketPayResult);
            }
        }
    }

    class a
    implements ICallback<auo> {
        private aup pa;
        private RocketPayInfo pb;

        public a(aup aup2, RocketPayInfo rocketPayInfo) {
            this.pa = aup2;
            this.pb = rocketPayInfo;
        }

        public void a(@Nullable auo auo2) {
            if (auo2 == null) {
                auo auo3 = new auo().bD(-1).iW("success, but OrderResponse is null");
                this.b(auo3);
                return;
            }
            I18nPayInfo i18nPayInfo = uz.transfrom(auo2.azG, this.pb);
            if (i18nPayInfo == null || i18nPayInfo.isLocalSharkBlock()) {
                auo auo4 = new auo().bD(-40001).iW("shark local blocking");
                Timber.tag((String)vb.TAG).e("shark local blocking", new Object[0]);
                this.b(auo4);
            } else {
                this.pa.FS();
                this.a(i18nPayInfo);
                this.pb.setAmount((long)i18nPayInfo.getPrice());
                this.c(this.pb, i18nPayInfo);
            }
            vb.this.mContext = null;
            vb.this.oQ = false;
        }

        protected void c(RocketPayInfo rocketPayInfo, I18nPayInfo i18nPayInfo) {
            vb.this.a(vb.this.mContext, rocketPayInfo, i18nPayInfo);
        }

        private void a(I18nPayInfo i18nPayInfo) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("order_id", (Object)i18nPayInfo.getOrderId());
                auh.c((RocketPayInfo)this.pb, (JSONObject)jSONObject);
            }
            catch (JSONException jSONException) {
                Timber.tag((String)vb.TAG).e(jSONException.getLocalizedMessage(), new Object[0]);
            }
        }

        public void b(@Nullable auo auo2) {
            int n2 = auo2 == null ? -2 : auo2.code;
            String string2 = auo2 == null ? "Unknown" : auo2.msg;
            RocketPayResult rocketPayResult = RocketPayResult.newRocketErrorPayResult((int)n2, (String)string2);
            this.pa.r(n2, string2);
            this.a(rocketPayResult);
            vb.this.mContext = null;
            vb.this.oQ = false;
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("error_code", (Object)String.valueOf(n2));
                jSONObject.put("error_msg", (Object)string2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            auh.d((RocketPayInfo)this.pb, (JSONObject)jSONObject);
        }

        protected void a(RocketPayResult rocketPayResult) {
            IPayCallback iPayCallback = vb.this.oJ;
            if (iPayCallback != null) {
                iPayCallback.onFailed((Object)rocketPayResult);
            }
        }

        public /* synthetic */ void onFailed(@Nullable Object object) {
            this.b((auo)object);
        }

        public /* synthetic */ void onSuccess(@Nullable Object object) {
            this.a((auo)object);
        }
    }
}

