/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.sdk.module.account.mailbox;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigation;
import com.bytedance.ttgame.channel.R;
import com.bytedance.ttgame.framework.module.network.Resource;
import com.bytedance.ttgame.sdk.module.account.api.TTUserInfo;
import com.bytedance.ttgame.sdk.module.account.mailbox.viewmodel.MailboxViewModel;
import com.bytedance.ttgame.sdk.module.account.pojo.UserInfoResponse;
import com.bytedance.ttgame.sdk.module.account.utils.PlatformDebug;
import com.bytedance.ttgame.sdk.module.core.internal.SdkCoreData;
import g.toutiao.vr;
import g.toutiao.ye;
import g.toutiao.yg;
import g.toutiao.yh;
import g.toutiao.yi;
import g.toutiao.zk;

public class AssociatedMailboxFragment
extends Fragment
implements View.OnClickListener {
    private EditText vb;
    private EditText vc;
    private TextView vd;
    private ImageView ve;
    private ImageView vf;
    private Button vg;
    private MailboxViewModel vh;
    private yh vi;
    private ImageView ti;
    private String email;
    private String jI;
    private ye vj;
    private TTUserInfo vk;
    private ImageView qI;

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        if (null != this.getArguments()) {
            this.jI = this.getArguments().getString("source", "");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.fragment_associated_mailbox, viewGroup, false);
        return view;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.vb = (EditText)view.findViewById(R.id.et_email);
        this.vc = (EditText)view.findViewById(R.id.et_code);
        this.vd = (TextView)view.findViewById(R.id.send_code);
        this.ve = (ImageView)view.findViewById(R.id.img_clear_email);
        this.vf = (ImageView)view.findViewById(R.id.img_clear_code);
        this.vg = (Button)view.findViewById(R.id.btn_ok);
        this.ti = (ImageView)view.findViewById(R.id.img_back);
        if (TextUtils.isEmpty((CharSequence)this.jI)) {
            this.ti.setVisibility(8);
        }
        this.ve.setOnClickListener((View.OnClickListener)this);
        this.vd.setOnClickListener((View.OnClickListener)this);
        this.vf.setOnClickListener((View.OnClickListener)this);
        this.vg.setOnClickListener((View.OnClickListener)this);
        this.ti.setOnClickListener((View.OnClickListener)this);
        this.vk = vr.getInstance().getTTUserInfo();
        this.qI = (ImageView)view.findViewById(R.id.img_close);
        this.qI.setOnClickListener((View.OnClickListener)this);
    }

    public void onActivityCreated(@Nullable Bundle bundle) {
        super.onActivityCreated(bundle);
        yg yg2 = new yg();
        yi yi2 = yi.getInstance(yg2);
        this.vh = (MailboxViewModel)ViewModelProviders.of((Fragment)this, (ViewModelProvider.Factory)yi2).get(MailboxViewModel.class);
        this.vh.sendEmailCodeResult().observe((LifecycleOwner)this, this::h);
        this.vh.bindEmailResult().observe((LifecycleOwner)this, this::i);
        this.aR();
        this.vj = new ye();
    }

    private void h(Resource<UserInfoResponse> resource) {
        if (resource != null) {
            switch (resource.status) {
                case SUCCESS: {
                    UserInfoResponse userInfoResponse = (UserInfoResponse)resource.data;
                    if (userInfoResponse == null) break;
                    if (userInfoResponse.code == 0) {
                        if (this.vk != null) {
                            this.vj.sendCodeSuccessMonitor(this.vk.getUserId());
                        }
                        this.vi = new yh(this.vd, 60000L, 1000L);
                        this.vi.start();
                        break;
                    }
                    PlatformDebug.t((Context)SdkCoreData.getInstance().getAppContext(), (String)userInfoResponse.message);
                    if (this.vk != null) {
                        this.vj.sendCodeFailMonitor(this.vk.getUserId(), userInfoResponse.code, userInfoResponse.message);
                        break;
                    }
                    this.vj.sendCodeFailMonitor(-1L, userInfoResponse.code, userInfoResponse.message);
                    break;
                }
                case ERROR: {
                    this.netWorkError();
                    if (this.vk != null) {
                        this.vj.sendCodeFailMonitor(this.vk.getUserId(), -3000, resource.message);
                        break;
                    }
                    this.vj.sendCodeFailMonitor(-1L, -3000, resource.message);
                }
            }
        }
    }

    private void i(Resource<UserInfoResponse> resource) {
        ((zk)this.getActivity()).dismissLoadingDialog();
        if (resource != null) {
            switch (resource.status) {
                case SUCCESS: {
                    UserInfoResponse userInfoResponse = (UserInfoResponse)resource.data;
                    if (userInfoResponse == null) break;
                    if (userInfoResponse.code == 0) {
                        if (!TextUtils.isEmpty((CharSequence)this.jI)) {
                            this.aS();
                        }
                        TTUserInfo tTUserInfo = vr.getInstance().getTTUserInfo();
                        if (tTUserInfo != null) {
                            tTUserInfo.setEmail(this.replaceUserName(this.email));
                        }
                        if (tTUserInfo == null) break;
                        this.vj.associateEmailSuccessMonitor(tTUserInfo.getUserId());
                        break;
                    }
                    PlatformDebug.t((Context)SdkCoreData.getInstance().getAppContext(), (String)userInfoResponse.message);
                    if (this.vk != null) {
                        this.vj.associateEmailFailMonitor(this.vk.getUserId(), userInfoResponse.code, userInfoResponse.message);
                        break;
                    }
                    this.vj.associateEmailFailMonitor(-1L, userInfoResponse.code, userInfoResponse.message);
                    break;
                }
                case ERROR: {
                    this.netWorkError();
                    if (this.vk != null) {
                        this.vj.associateEmailFailMonitor(this.vk.getUserId(), -3000, resource.message);
                        break;
                    }
                    this.vj.associateEmailFailMonitor(-1L, -3000, resource.message);
                }
            }
        }
    }

    private void aR() {
        this.vb.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
            }

            public void onTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
            }

            public void afterTextChanged(Editable editable) {
                int n2 = editable.length();
                if (n2 == 0) {
                    AssociatedMailboxFragment.this.vd.setClickable(false);
                    AssociatedMailboxFragment.this.vg.setEnabled(false);
                    AssociatedMailboxFragment.this.ve.setVisibility(8);
                } else {
                    AssociatedMailboxFragment.this.vd.setClickable(true);
                    AssociatedMailboxFragment.this.ve.setVisibility(0);
                    if (!TextUtils.isEmpty((CharSequence)AssociatedMailboxFragment.this.vc.getText().toString().trim())) {
                        AssociatedMailboxFragment.this.vg.setEnabled(true);
                    }
                }
            }
        });
        this.vc.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
            }

            public void onTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
            }

            public void afterTextChanged(Editable editable) {
                int n2 = editable.length();
                if (n2 == 0) {
                    AssociatedMailboxFragment.this.vg.setEnabled(false);
                    AssociatedMailboxFragment.this.vf.setVisibility(8);
                } else {
                    AssociatedMailboxFragment.this.vf.setVisibility(0);
                    if (!TextUtils.isEmpty((CharSequence)AssociatedMailboxFragment.this.vc.getText().toString().trim())) {
                        AssociatedMailboxFragment.this.vg.setEnabled(true);
                    }
                }
            }
        });
    }

    public void onClick(View view) {
        if (view.getId() == R.id.img_clear_email) {
            this.vb.setText((CharSequence)"");
        } else if (view.getId() == R.id.img_clear_code) {
            this.vc.setText((CharSequence)"");
        } else if (view.getId() == R.id.send_code) {
            this.email = this.vb.getText().toString().trim();
            if (!TextUtils.isEmpty((CharSequence)this.email)) {
                this.vj.startSendCode();
                this.vh.startSendEmailCode(this.email);
            }
        } else if (view.getId() == R.id.img_back) {
            Navigation.findNavController((View)view).navigateUp();
        } else if (view.getId() == R.id.btn_ok) {
            String string2;
            if (TextUtils.isEmpty((CharSequence)this.email)) {
                this.email = this.vb.getText().toString().trim();
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = this.vc.getText().toString().trim()))) {
                this.vj.startAssociateEmail();
                if (this.getActivity() != null && !this.getActivity().isFinishing() && this.getActivity() instanceof zk) {
                    ((zk)this.getActivity()).showLoading();
                }
                this.vh.startBindEmail(string2);
            }
        } else if (view.getId() == R.id.img_close && this.getActivity() != null && !this.getActivity().isFinishing()) {
            this.getActivity().finish();
        }
    }

    private void netWorkError() {
        String string2 = SdkCoreData.getInstance().getAppContext().getResources().getString(R.string.gsdk_account_network_error);
        PlatformDebug.t((Context)SdkCoreData.getInstance().getAppContext(), (String)string2);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.vi != null) {
            this.vi.cancel();
        }
        if (this.getActivity() != null && !this.getActivity().isFinishing()) {
            ((zk)this.getActivity()).dismissLoadingDialog();
        }
    }

    private void aS() {
        try {
            this.getFragmentManager().popBackStack(null, 1);
            NavOptions navOptions = new NavOptions.Builder().setPopUpTo(R.id.user_center, true).build();
            if (this.getActivity() != null && !this.getActivity().isFinishing()) {
                Navigation.findNavController((View)this.getActivity().findViewById(R.id.my_nav_host_fragment)).navigate(R.id.user_center, null, navOptions);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String replaceUserName(String string2) {
        if (string2.indexOf("@") >= 0) {
            String string3 = string2.substring(0, string2.indexOf("@"));
            if (string3.length() < 3) {
                return string3;
            }
            StringBuilder stringBuilder = new StringBuilder();
            string3 = string3.substring(0, 3);
            stringBuilder.append(string3).append("***");
            return stringBuilder.toString();
        }
        return "";
    }
}

